/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IItemStackDisplay;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketItemStackDisplay
extends PacketCoordinates {
    private ItemStack itemStack;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketItemStackDisplay(data);
    }

    private PacketItemStackDisplay(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public <T extends TileForestry> PacketItemStackDisplay(T tile, ItemStack itemStack) {
        super(PacketId.GUI_ITEMSTACK, tile);
        this.itemStack = itemStack;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeItemStack(this.itemStack);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.itemStack = data.readItemStack();
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IItemStackDisplay) {
            ((IItemStackDisplay)tile).handleItemStackForDisplay(this.itemStack);
        }
    }
}

