/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.core.interfaces.ICrafter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class SlotCrafter
extends SlotCrafting {
    private final ICrafter crafter;
    private final IInventory craftMatrix;

    public SlotCrafter(EntityPlayer player, IInventory craftMatrix, ICrafter crafter, int slot, int xPos, int yPos) {
        super(player, craftMatrix, craftMatrix, slot, xPos, yPos);
        this.crafter = crafter;
        this.craftMatrix = craftMatrix;
    }

    public boolean isItemValid(ItemStack par1ItemStack) {
        return false;
    }

    public ItemStack decrStackSize(int amount) {
        if (!this.getHasStack()) {
            return null;
        }
        return this.getStack();
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.crafter.canTakeStack(this.getSlotIndex());
    }

    public ItemStack getStack() {
        return this.crafter.getResult();
    }

    public boolean getHasStack() {
        return this.getStack() != null && this.crafter.canTakeStack(this.getSlotIndex());
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, this.craftMatrix);
        this.onCrafting(itemStack, itemStack.stackSize);
        this.crafter.takenFromSlot(this.getSlotIndex(), player);
    }
}

