/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IToolPipette;
import forestry.core.gui.ContainerTile;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketId;
import forestry.core.network.PacketSlotClick;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class ContainerLiquidTanks<T extends TileEntity & IStreamableGui>
extends ContainerTile<T> {
    protected ContainerLiquidTanks(T tile, InventoryPlayer playerInventory, int xInv, int yInv) {
        super(tile, playerInventory, xInv, yInv);
    }

    @SideOnly(value=Side.CLIENT)
    public void handlePipetteClickClient(int slot, EntityPlayer player) {
        ItemStack itemstack = player.inventory.getItemStack();
        if (itemstack == null || !(itemstack.getItem() instanceof IToolPipette)) {
            return;
        }
        Proxies.net.sendToServer(new PacketSlotClick(PacketId.PIPETTE_CLICK, this.tile, slot));
    }

    public void handlePipetteClick(int slot, EntityPlayerMP player) {
        ItemStack itemstack = player.inventory.getItemStack();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.getItem();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        IFluidTank tank = ((ILiquidTankContainer)this.tile).getTankManager().getTank(slot);
        int liquidAmount = tank.getFluidAmount();
        if (pipette.canPipette(itemstack) && liquidAmount > 0) {
            if (liquidAmount > 0) {
                FluidStack fillAmount = tank.drain(1000, false);
                int filled = pipette.fill(itemstack, fillAmount, true);
                tank.drain(filled, true);
                player.updateHeldItem();
            }
        } else {
            FluidStack potential = pipette.drain(itemstack, pipette.getCapacity(itemstack), false);
            if (potential != null) {
                pipette.drain(itemstack, tank.fill(potential, true), true);
                player.updateHeldItem();
            }
        }
    }

    public void updateProgressBar(int messageId, int data) {
        super.updateProgressBar(messageId, data);
        ((ILiquidTankContainer)this.tile).getTankManager().processGuiUpdate(messageId, data);
        ((ILiquidTankContainer)this.tile).getGUINetworkData(messageId, data);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        ((ILiquidTankContainer)this.tile).getTankManager().updateGuiData(this, this.crafters);
        for (Object crafter : this.crafters) {
            ((ILiquidTankContainer)this.tile).sendGUINetworkData(this, (ICrafting)crafter);
        }
    }

    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        ((ILiquidTankContainer)this.tile).getTankManager().initGuiData(this, icrafting);
    }

    public IFluidTank getTank(int slot) {
        return ((ILiquidTankContainer)this.tile).getTankManager().getTank(slot);
    }
}

