/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.recipes.nei.INBTMatchingCachedRecipe;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.tiles.TileFabricator;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerFabricator
extends RecipeHandlerBase {
    public List<PositionedStack> getIngredientStacks(int recipe) {
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
    }

    @Override
    public String getRecipeID() {
        return "forestry.fabricator";
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.for.factory2.0.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/fabricator.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(117, 44, 14, 13);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFabricator.class;
    }

    @Override
    public void loadAllRecipes() {
        for (IFabricatorRecipe recipe : TileFabricator.RecipeManager.recipes) {
            this.arecipes.add(new CachedFabricatorRecipe(recipe, true));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IFabricatorRecipe recipe : TileFabricator.RecipeManager.recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getRecipeOutput(), (ItemStack)result)) continue;
            CachedFabricatorRecipe crecipe = new CachedFabricatorRecipe(recipe, true);
            NEIUtils.setResultPermutationNBT(crecipe, result);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (IFabricatorRecipe recipe : TileFabricator.RecipeManager.recipes) {
            CachedFabricatorRecipe crecipe = new CachedFabricatorRecipe(recipe);
            if ((crecipe.inputs == null || !crecipe.contains(crecipe.inputs, ingred)) && (crecipe.smeltingInput == null || !crecipe.contains(crecipe.smeltingInput, ingred))) continue;
            crecipe.generatePermutations();
            NEIUtils.setIngredientPermutationNBT(crecipe, ingred);
            crecipe.setIngredientPermutation(crecipe.smeltingInput, ingred);
            this.arecipes.add(crecipe);
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (IFabricatorRecipe recipe : TileFabricator.RecipeManager.recipes) {
            if (!NEIUtils.areFluidsSameType(recipe.getLiquid(), ingredient)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(recipe, true));
        }
    }

    @Override
    public List<String> provideItemTooltip(GuiRecipe guiRecipe, ItemStack itemStack, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideItemTooltip(guiRecipe, itemStack, currenttip, crecipe, relMouse);
        if (new Rectangle(20, 9, 18, 18).contains(relMouse)) {
            for (TileFabricator.Smelting smelting : TileFabricator.RecipeManager.smeltings) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)smelting.getResource(), (ItemStack)itemStack) || smelting.getProduct() == null) continue;
                currenttip.add(EnumChatFormatting.GRAY.toString() + NEIUtils.translate("handler.forestry.fabricator.worth") + " " + smelting.getProduct().amount + " mB");
            }
        }
        return currenttip;
    }

    private static Map<Fluid, List<TileFabricator.Smelting>> getSmeltingInputs() {
        HashMap<Fluid, List<TileFabricator.Smelting>> smeltingInputs = new HashMap<Fluid, List<TileFabricator.Smelting>>();
        for (TileFabricator.Smelting smelting : TileFabricator.RecipeManager.smeltings) {
            Fluid fluid = smelting.getProduct().getFluid();
            if (!smeltingInputs.containsKey(fluid)) {
                smeltingInputs.put(fluid, new ArrayList());
            }
            ((List)smeltingInputs.get(fluid)).add(smelting);
        }
        return smeltingInputs;
    }

    public class CachedFabricatorRecipe
    extends RecipeHandlerBase.CachedBaseRecipe
    implements INBTMatchingCachedRecipe {
        private final boolean preservesNbt;
        public List<PositionedStack> smeltingInput = new ArrayList<PositionedStack>();
        public PositionedFluidTank tank;
        public List<PositionedStack> inputs = new ArrayList<PositionedStack>();
        public PositionedStack output;

        public CachedFabricatorRecipe(IFabricatorRecipe recipe, boolean genPerms) {
            this.preservesNbt = recipe.preservesNbt();
            if (recipe.getLiquid() != null) {
                this.tank = new PositionedFluidTank(recipe.getLiquid(), 2000, new Rectangle(21, 37, 16, 16));
                ArrayList<ItemStack> smeltingInput = new ArrayList<ItemStack>();
                for (TileFabricator.Smelting s : (List)NEIHandlerFabricator.getSmeltingInputs().get(recipe.getLiquid().getFluid())) {
                    smeltingInput.add(s.getResource());
                }
                if (!smeltingInput.isEmpty()) {
                    this.smeltingInput.add(new PositionedStack(smeltingInput, 21, 10));
                }
            }
            if (recipe != null) {
                if (recipe.getIngredients() != null) {
                    this.setIngredients(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients());
                }
                if (recipe.getPlan() != null) {
                    this.inputs.add(new PositionedStack((Object)recipe.getPlan(), 134, 6));
                }
                if (recipe.getRecipeOutput() != null) {
                    this.output = new PositionedStack((Object)recipe.getRecipeOutput(), 134, 42);
                }
            }
            if (genPerms) {
                this.generatePermutations();
            }
        }

        public CachedFabricatorRecipe(IFabricatorRecipe recipe) {
            this(recipe, false);
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    Object item = items[y * width + x];
                    if (item == null || item instanceof ItemStack[] && ((ItemStack[])item).length == 0 || item instanceof List && ((List)item).size() == 0) continue;
                    PositionedStack stack = new PositionedStack(item, 62 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.inputs.add(stack);
                }
            }
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            if (this.preservesNbt) {
                Random random = new Random(cycle);
                cycle = Math.abs(random.nextInt());
                NBTTagCompound nbt = null;
                for (PositionedStack ingredient : ingredients) {
                    ingredient.setPermutationToRender(cycle % ingredient.items.length);
                    if (!ingredient.item.hasTagCompound()) continue;
                    nbt = ingredient.item.getTagCompound();
                }
                this.output.setPermutationToRender(cycle % this.output.items.length);
                if (nbt != null) {
                    this.output.item.setTagCompound((NBTTagCompound)nbt.copy());
                }
            } else {
                return super.getCycledIngredients(cycle, ingredients);
            }
            return ingredients;
        }

        @Override
        public boolean preservesNBT() {
            return this.preservesNbt;
        }

        @Override
        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return super.getCycledIngredients(NEIHandlerFabricator.this.cycleticks / 40, this.smeltingInput);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHandlerFabricator.this.cycleticks / 20, this.inputs);
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.tank;
        }

        public void generatePermutations() {
            for (PositionedStack p : this.inputs) {
                p.generatePermutations();
            }
        }
    }
}

