/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

import forestry.core.GuiHandlerBase;
import forestry.core.network.GuiId;
import forestry.food.gui.ContainerInfuser;
import forestry.food.gui.GuiInfuser;
import forestry.food.items.ItemInfuser.InfuserInventory;

public class GuiHandlerFood extends GuiHandlerBase {
	@Override
	public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {

		if (id >= GuiId.values().length) {
			return null;
		}

		switch (GuiId.values()[id]) {

			case InfuserGUI:
				ItemStack infuser = player.getCurrentEquippedItem();
				if (infuser == null) {
					return null;
				}
				return new GuiInfuser(player.inventory, new InfuserInventory(player, infuser));

			default:
				return null;
		}
	}

	@Override
	public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {

		if (id >= GuiId.values().length) {
			return null;
		}

		switch (GuiId.values()[id]) {

			case InfuserGUI:
				ItemStack infuser = player.getCurrentEquippedItem();
				if (infuser == null) {
					return null;
				}
				return new ContainerInfuser(player.inventory, new InfuserInventory(player, infuser));

			default:
				return null;

		}
	}
}
