/*******************************************************************************
 * Copyright 2011-2014 by SirSengir
 * 
 * This work is licensed under a Creative Commons Attribution-NonCommercial-NoDerivs 3.0 Unported License.
 * 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-nd/3.0/.
 ******************************************************************************/
package forestry.farming.logic;

import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.config.Defaults;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Vect;

public class FarmableGourd implements IFarmable {

	public ItemStack seed;
	public ItemStack stem;
	public ItemStack fruit;

	public FarmableGourd(ItemStack seed, ItemStack stem, ItemStack fruit) {
		this.seed = seed;
		this.stem = stem;
		this.fruit = fruit;
	}

	@Override
	public boolean isSaplingAt(World world, int x, int y, int z) {
		if (world.isAirBlock(x, y, z))
			return false;

		if (!StackUtils.equals(world.getBlock(x, y, z), stem))
			return false;

		return true;
	}

	@Override
	public ICrop getCropAt(World world, int x, int y, int z) {
		if (world.isAirBlock(x, y, z))
			return null;

		if (!StackUtils.equals(world.getBlock(x, y, z), fruit))
			return null;

		if (world.getBlockMetadata(x, y, z) != fruit.getItemDamage())
			return null;

		return new CropBlock(world, StackUtils.getBlock(fruit), fruit.getItemDamage(), new Vect(x, y, z));
	}

	@Override
	public boolean isGermling(ItemStack itemstack) {
		return seed.isItemEqual(itemstack);
	}

	@Override
	public boolean isWindfall(ItemStack itemstack) {
		return false;
	}

	@Override
	public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
		return world.setBlock(x, y, z, StackUtils.getBlock(stem), 0, Defaults.FLAG_BLOCK_SYNCH);
	}

}
