/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.blocks;

import java.util.Locale;
import java.util.Random;

import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.config.Constants;

public class BlockMushroom extends BlockBush implements IItemModelRegister, IGrowable {

	public static final PropertyEnum<MushroomType> VARIANT = PropertyEnum.func_177709_a("mushroom", MushroomType.class);
	public static final PropertyBool MATURE = PropertyBool.func_177716_a("mature");

	public enum MushroomType implements IStringSerializable {
		BROWN {
			@Override
			public ItemStack getDrop() {
				return new ItemStack(Blocks.field_150338_P);
			}
		},
		RED {
			@Override
			public ItemStack getDrop() {
				return new ItemStack(Blocks.field_150337_Q);
			}
		};

		public abstract ItemStack getDrop();

		@Override
		public String func_176610_l() {
			return name().toLowerCase(Locale.ENGLISH);
		}
	}

	private final WorldGenerator[] generators;

	public BlockMushroom() {
		func_149711_c(0.0f);
		this.generators = new WorldGenerator[]{new WorldGenBigMushroom(Blocks.field_150420_aW), new WorldGenBigMushroom(Blocks.field_150419_aX)};
		func_149647_a(null);
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, MushroomType.BROWN).func_177226_a(MATURE, false));
		func_149675_a(true);
		func_149672_a(SoundType.field_185850_c);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, VARIANT, MATURE);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(VARIANT).ordinal() | ((state.func_177229_b(MATURE) ? 1 : 0) << 2);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(VARIANT, MushroomType.values()[meta % 2]).func_177226_a(MATURE, (meta >> 2) == 1);
	}

	@Override
	public boolean func_149653_t() {
		return true;
	}
	
	@Override
	public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		MushroomType type = state.func_177229_b(VARIANT);
		drops.add(type.getDrop());
	}
	
	@Override
	public boolean func_176196_c(World worldIn, BlockPos pos) {
		return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, this.func_176223_P());
	}

	@Override
	protected boolean func_185514_i(IBlockState state) {
		return state.func_185913_b();
	}

	@Override
	public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
		if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
			IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
			return iblockstate.func_177230_c() == Blocks.field_150391_bh || (iblockstate.func_177230_c() == Blocks.field_150346_d && iblockstate.func_177229_b(BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL || worldIn.func_175699_k(pos) < 13 && iblockstate.func_177230_c().canSustainPlant(iblockstate, worldIn, pos.func_177977_b(), net.minecraft.util.EnumFacing.UP, this));
		} else {
			return false;
		}
	}

	@Override
	public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
		if (world.field_72995_K || rand.nextInt(2) != 0) {
			return;
		}

		IBlockState blockState = world.func_180495_p(pos);
		if (!blockState.func_177229_b(MATURE)) {
			world.func_180501_a(pos, blockState.func_177226_a(MATURE, true), Constants.FLAG_BLOCK_SYNC);
		} else {
			int lightValue1 = world.func_175671_l(pos.func_177984_a());
			if (lightValue1 <= 7) {
				generateGiantMushroom(world, pos, blockState, rand);
			}
		}
	}

	public void generateGiantMushroom(World world, BlockPos pos, IBlockState state, Random rand) {
		MushroomType type = state.func_177229_b(VARIANT);

		world.func_175698_g(pos);
		if (!generators[type.ordinal()].func_180709_b(world, rand, pos)) {
			world.func_180501_a(pos, func_176203_a(type.ordinal()), 0);
		}
	}

	public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
		this.generateGiantMushroom(worldIn, pos, state, rand);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		list.add(new ItemStack(this, 1, 0));
		list.add(new ItemStack(this, 1, 1));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0, "minecraft", "brown_mushroom");
		manager.registerItemModel(item, 1, "minecraft", "red_mushroom");
	}

	@Override
	public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
		return true;
	}

	@Override
	public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
		return worldIn.field_73012_v.nextFloat() < 0.45D;
	}

	@Override
	public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
		this.grow(worldIn, pos, state, rand);
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
		return state.func_177229_b(VARIANT).getDrop();
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return state.func_177229_b(VARIANT).ordinal();
	}
}
