/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.climate.EnumClimatiserModes;
import forestry.api.climate.EnumClimatiserTypes;
import forestry.api.climate.IClimateInfo;
import forestry.api.climate.IClimatePosition;
import forestry.api.climate.IClimateRegion;
import forestry.api.climate.IClimatiserDefinition;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.climate.BiomeClimateInfo;
import forestry.greenhouse.GreenhouseClimateSource;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.tiles.TileGreenhouseWindow;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class GreenhouseClimateWindow
extends GreenhouseClimateSource<TileGreenhouseWindow> {
    @Nullable
    private Biome biome;

    public GreenhouseClimateWindow(int ticksForChange) {
        super(ticksForChange);
    }

    @Override
    public boolean changeClimate(int tickCount, IClimateRegion region) {
        if (this.provider == null) {
            return false;
        }
        World world = region.getWorld();
        IClimatiserDefinition definition = ((TileGreenhouseWindow)this.provider).getDefinition();
        Object logic = ((TileGreenhouseWindow)this.provider).getMultiblockLogic();
        IMultiblockController controller = logic.getController();
        Set<BlockPos> positionsInRange = ((TileGreenhouseWindow)this.provider).getPositionsInRange();
        boolean hasChange = false;
        TileGreenhouseWindow.WindowMode windowMode = ((TileGreenhouseWindow)this.provider).getMode();
        if (logic.isConnected() && controller.isAssembled() && controller instanceof IGreenhouseControllerInternal && positionsInRange.iterator().hasNext()) {
            IGreenhouseControllerInternal greenhouseInternal = (IGreenhouseControllerInternal)controller;
            IClimateInfo climateInfo = this.getClimateControl(greenhouseInternal);
            float controlTemp = climateInfo.getTemperature();
            float controlHum = climateInfo.getHumidity();
            if (!greenhouseInternal.canWork()) {
                if (windowMode == TileGreenhouseWindow.WindowMode.OPEN) {
                    windowMode = TileGreenhouseWindow.WindowMode.CONTROL;
                    ((TileGreenhouseWindow)this.provider).setMode(windowMode);
                }
            } else if (windowMode == TileGreenhouseWindow.WindowMode.CONTROL) {
                windowMode = TileGreenhouseWindow.WindowMode.OPEN;
                ((TileGreenhouseWindow)this.provider).setMode(windowMode);
            }
            if (windowMode == TileGreenhouseWindow.WindowMode.OPEN) {
                EnumClimatiserTypes type = definition.getType();
                EnumClimatiserModes mode = definition.getMode();
                float maxChange = definition.getChange();
                for (BlockPos pos : positionsInRange) {
                    IClimatePosition position = region.getPosition(pos);
                    if (position == null) continue;
                    double distance = pos.func_177951_i((Vec3i)((TileGreenhouseWindow)this.provider).getCoordinates());
                    float change = maxChange;
                    if (distance > 0.0) {
                        change = (float)((double)maxChange / distance);
                    }
                    if (this.canChange(type, EnumClimatiserTypes.TEMPERATURE)) {
                        if (position.getTemperature() < controlTemp) {
                            if (this.canChange(mode, EnumClimatiserModes.POSITIVE)) {
                                position.addTemperature(Math.min(change, controlTemp - position.getTemperature()));
                                hasChange = true;
                            }
                        } else if (position.getTemperature() > controlTemp && this.canChange(mode, EnumClimatiserModes.NEGATIVE)) {
                            position.addTemperature(-Math.min(position.getTemperature() - controlTemp, change));
                            hasChange = true;
                        }
                    }
                    if (!this.canChange(type, EnumClimatiserTypes.HUMIDITY)) continue;
                    if (position.getHumidity() < controlHum) {
                        if (!this.canChange(mode, EnumClimatiserModes.POSITIVE)) continue;
                        position.addHumidity(Math.min(change, controlHum - position.getHumidity()));
                        hasChange = true;
                        continue;
                    }
                    if (!(position.getHumidity() > controlHum) || !this.canChange(mode, EnumClimatiserModes.NEGATIVE)) continue;
                    position.addHumidity(-Math.min(position.getHumidity() - controlHum, change));
                    hasChange = true;
                }
            }
        }
        return hasChange;
    }

    @Override
    protected IClimateInfo getClimateControl(IGreenhouseControllerInternal greenhouseInternal) {
        if (this.biome == null) {
            BlockPos pos = ((TileGreenhouseWindow)this.provider).getCoordinates();
            World world = ((TileGreenhouseWindow)this.provider).func_145831_w();
            this.biome = world.func_180494_b(pos);
        }
        return BiomeClimateInfo.getInfo(this.biome);
    }
}

