/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMushroom
extends BlockBush
implements IItemModelRegister,
IGrowable {
    public static final PropertyEnum<MushroomType> VARIANT = PropertyEnum.func_177709_a((String)"mushroom", MushroomType.class);
    public static final PropertyBool MATURE = PropertyBool.func_177716_a((String)"mature");
    private final WorldGenerator[] generators;

    public BlockMushroom() {
        this.func_149711_c(0.0f);
        this.generators = new WorldGenerator[]{new WorldGenBigMushroom(Blocks.field_150420_aW), new WorldGenBigMushroom(Blocks.field_150419_aX)};
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)MushroomType.BROWN)).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, MATURE});
    }

    public int func_176201_c(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b(VARIANT))).ordinal() | ((Boolean)state.func_177229_b((IProperty)MATURE) != false ? 1 : 0) << 2;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MushroomType.values()[meta % 2])).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(meta >> 2 == 1));
    }

    public boolean func_149653_t() {
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        MushroomType type = (MushroomType)((Object)state.func_177229_b(VARIANT));
        drops.add((Object)type.getDrop());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, this.func_176223_P());
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_185913_b();
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
            return iblockstate.func_177230_c() == Blocks.field_150391_bh || iblockstate.func_177230_c() == Blocks.field_150346_d && iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL || worldIn.func_175699_k(pos) < 13 && iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || rand.nextInt(2) != 0) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (!((Boolean)blockState.func_177229_b((IProperty)MATURE)).booleanValue()) {
            world.func_180501_a(pos, blockState.func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(true)), 2);
        } else {
            int lightValue1 = world.func_175671_l(pos.func_177984_a());
            if (lightValue1 <= 7) {
                this.generateGiantMushroom(world, pos, blockState, rand);
            }
        }
    }

    public void generateGiantMushroom(World world, BlockPos pos, IBlockState state, Random rand) {
        MushroomType type = (MushroomType)((Object)state.func_177229_b(VARIANT));
        world.func_175698_g(pos);
        if (!this.generators[type.ordinal()].func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, this.func_176203_a(type.ordinal()), 0);
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.generateGiantMushroom(worldIn, pos, state, rand);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "minecraft", "brown_mushroom");
        manager.registerItemModel(item, 1, "minecraft", "red_mushroom");
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ((MushroomType)((Object)state.func_177229_b(VARIANT))).getDrop();
    }

    public int func_180651_a(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum MushroomType implements IStringSerializable
    {
        BROWN{

            @Override
            public ItemStack getDrop() {
                return new ItemStack((Block)Blocks.field_150338_P);
            }
        }
        ,
        RED{

            @Override
            public ItemStack getDrop() {
                return new ItemStack((Block)Blocks.field_150337_Q);
            }
        };


        public abstract ItemStack getDrop();

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

