package forestry.factory.recipes.jei.carpenter;

import java.util.Map.Entry;

import forestry.core.utils.NetworkUtil;
import forestry.factory.gui.ContainerCarpenter;
import forestry.factory.network.packets.PacketRecipeTransferRequest;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class CarpenterRecipeTransferHandler implements IRecipeTransferHandler<ContainerCarpenter> {

	@Override
	public Class<ContainerCarpenter> getContainerClass() {
		return ContainerCarpenter.class;
	}

	@Override
	public IRecipeTransferError transferRecipe(ContainerCarpenter container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
		if (doTransfer) {
			IInventory craftingInventory = container.getCarpenter().getCraftingInventory();
			NonNullList<ItemStack> items = NonNullList.func_191197_a(9, ItemStack.field_190927_a);
			for (Entry<Integer, ? extends IGuiIngredient<ItemStack>> guiIngredientEntry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
				IGuiIngredient<ItemStack> guiIngredient = guiIngredientEntry.getValue();
				if (guiIngredient != null && guiIngredient.getDisplayedIngredient() != null) {
					int index = guiIngredientEntry.getKey();
					if (index >= 2) {
						ItemStack ingredient = guiIngredient.getDisplayedIngredient().func_77946_l();
						craftingInventory.func_70299_a(index - 2, ingredient);
						items.set(index - 2, ingredient);
					}
				}
			}
			NetworkUtil.sendToServer(new PacketRecipeTransferRequest(container.getCarpenter(), items));
		}
		return null;
	}

}
