/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.models.BlankModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.TRSRBakedModel;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelButterflyItem
extends BlankModel {
    @Nullable
    private static IModel modelButterfly;
    private static final Cache<IAlleleButterflySpecies, IBakedModel> cache;

    public static void onModelBake(ModelBakeEvent event) {
        modelButterfly = null;
        cache.invalidateAll();
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new ButterflyItemOverrideList();
    }

    private IBakedModel bakeModel(IButterfly butterfly) {
        ImmutableMap textures = ImmutableMap.of((Object)"butterfly", (Object)butterfly.getGenome().getPrimary().getItemTexture());
        if (modelButterfly == null) {
            try {
                modelButterfly = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry", "item/butterfly_ge"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (modelButterfly == null) {
                throw new IllegalArgumentException("Could not bake butterfly model");
            }
        }
        IModel retexturedModel = modelButterfly.retexture(textures);
        IBakedModel bakedModel = retexturedModel.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, DefaultTextureGetter.INSTANCE);
        return new TRSRBakedModel(bakedModel, -0.03125f, 0.25f - butterfly.getSize() * 0.37f, -0.03125f, butterfly.getSize() * 1.5f);
    }

    static {
        cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    private class ButterflyItemOverrideList
    extends ItemOverrideList {
        public ButterflyItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            IButterfly butterfly = ButterflyManager.butterflyRoot.getMember(stack);
            Preconditions.checkNotNull((Object)butterfly);
            IAlleleButterflySpecies primary = butterfly.getGenome().getPrimary();
            IBakedModel bakedModel = (IBakedModel)cache.getIfPresent((Object)primary);
            if (bakedModel == null) {
                bakedModel = ModelButterflyItem.this.bakeModel(butterfly);
                cache.put((Object)primary, (Object)bakedModel);
            }
            return bakedModel;
        }
    }
}

