package forestry.greenhouse.entities;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public abstract class SprinklerWater extends Particle {

	public SprinklerWater(World world, double x, double y, double z, Vec3d vector, ResourceLocation texture) {
		super(world, x, y, z, 0, 0, 0);
		this.field_70544_f = 0.3F;
		this.field_187129_i = vector.field_72450_a;
		this.field_187130_j = vector.field_72448_b;
		this.field_187131_k = vector.field_72449_c;
		this.field_70547_e = 15;
		this.func_187115_a(0.2f, 0.2f);
	}

	@Override
	public int func_70537_b() {
		return 1;
	}

	@Override
	public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
		float f6 = 0;
		float f7 = 1;
		float f8 = 0;
		float f9 = 1;
		float f10 = 0.1F * this.field_70544_f;
		float f11 = (float) (this.field_187123_c + (this.field_187126_f - this.field_187123_c) * rotationX - field_70556_an);
		float f12 = (float) (this.field_187124_d + (this.field_187127_g - this.field_187124_d) * rotationX - field_70554_ao);
		float f13 = (float) (this.field_187125_e + (this.field_187128_h - this.field_187125_e) * rotationX - field_70555_ap);
		TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
		textureManager.func_110577_a(FluidRegistry.WATER.getStill());
		int i = this.func_189214_a(partialTicks);
		int j = i >> 16 & 65535;
		int k = i & 65535;
		buffer.func_181662_b((f11 - rotationZ * f10 - rotationXZ * f10), (f12 - rotationYZ * f10), (f13 - rotationXY * f10 - f6 * f10)).func_181666_a(1F, 1F, 1F, 0.5F).func_187315_a(f7, f9).func_187314_a(j, k).func_181675_d();
		buffer.func_181662_b((f11 - rotationZ * f10 + rotationXZ * f10), (f12 + rotationYZ * f10), (f13 - rotationXY * f10 + f6 * f10)).func_181666_a(1F, 1F, 1F, 0.5F).func_187315_a(f7, f8).func_187314_a(j, k).func_181675_d();
		buffer.func_181662_b((f11 + rotationZ * f10 + rotationXZ * f10), (f12 + rotationYZ * f10), (f13 + rotationXY * f10 + f6 * f10)).func_181666_a(1F, 1F, 1F, 0.5F).func_187315_a(f6, f8).func_187314_a(j, k).func_181675_d();
		buffer.func_181662_b((f11 + rotationZ * f10 - rotationXZ * f10), (f12 - rotationYZ * f10), (f13 + rotationXY * f10 - f6 * f10)).func_181666_a(1F, 1F, 1F, 0.5F).func_187315_a(f6, f9).func_187314_a(j, k).func_181675_d();
	}

	// avoid calculating lighting for water, it is too much processing
	@Override
	public int func_189214_a(float p_189214_1_) {
		return 15728880;
	}
}
