/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import com.google.common.base.Preconditions;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.PacketBufferForestry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.GuiWorktable;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.inventory.InventoryWorktable;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private RecipeMemory recipeMemory;
    private final InventoryAdapterTile craftingDisplay;
    @Nullable
    private MemorizedRecipe currentRecipe;

    public TileWorktable() {
        this.setInternalInventory(new InventoryWorktable(this));
        this.craftingDisplay = new InventoryGhostCrafting<TileWorktable>(this, 10);
        this.recipeMemory = new RecipeMemory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.craftingDisplay.writeToNBT(nbttagcompound);
        this.recipeMemory.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.craftingDisplay.readFromNBT(nbttagcompound);
        this.recipeMemory = new RecipeMemory(nbttagcompound);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.craftingDisplay.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.craftingDisplay.readData(data);
        this.recipeMemory.readData(data);
    }

    public boolean hasRecipeConflict() {
        return this.currentRecipe != null && this.currentRecipe.hasRecipeConflict();
    }

    public void chooseNextConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.incrementRecipe();
        }
    }

    public void choosePreviousConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.decrementRecipe();
        }
    }

    @Override
    public ItemStack getResult(InventoryCrafting inventoryCrafting, World world) {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getCraftingResult(inventoryCrafting, world);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canTakeStack(int craftingSlotIndex) {
        return craftingSlotIndex != 9 || this.canCraftCurrentRecipe();
    }

    private boolean canCraftCurrentRecipe() {
        return this.craftRecipe(true);
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        return this.craftRecipe(false);
    }

    private boolean craftRecipe(boolean simulate) {
        TileWorktable inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        IRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe();
        if (selectedRecipe == null) {
            return false;
        }
        NonNullList<ItemStack> inventoryStacks = InventoryUtil.getStacks((IInventory)this);
        InventoryCraftingForestry crafting = RecipeUtil.getCraftRecipe(this.currentRecipe.getCraftMatrix(), inventoryStacks, this.field_145850_b, selectedRecipe);
        if (crafting == null) {
            return false;
        }
        NonNullList<ItemStack> recipeItems = InventoryUtil.getStacks((IInventory)crafting);
        if (simulate) {
            inventory = new InventoryBasic("copy", false, this.func_70302_i_());
            InventoryUtil.deepCopyInventoryContents((IInventory)this, (IInventory)inventory);
        } else {
            inventory = this;
        }
        if (!InventoryUtil.deleteExactSet((IInventory)inventory, recipeItems)) {
            return false;
        }
        if (!simulate && !this.field_145850_b.field_72995_K) {
            this.setCraftingDisplay((IInventory)crafting);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        Preconditions.checkState((this.currentRecipe != null ? 1 : 0) != 0);
        IRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe();
        Preconditions.checkState((selectedRecipe != null ? 1 : 0) != 0);
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        InventoryCraftingForestry craftMatrix = this.currentRecipe.getCraftMatrix();
        NonNullList remainingItems = selectedRecipe.func_179532_b((InventoryCrafting)craftMatrix.copy());
        ForgeHooks.setCraftingPlayer(null);
        for (ItemStack remainingItem : remainingItems) {
            if (remainingItem == null || remainingItem.func_190926_b() || InventoryUtil.tryAddStack((IInventory)this, remainingItem, true)) continue;
            player.func_71019_a(remainingItem, false);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recipeMemory.memorizeRecipe(this.field_145850_b.func_82737_E(), this.currentRecipe);
        }
    }

    @Override
    @Nullable
    public IRecipe getRecipeUsed() {
        if (this.currentRecipe == null) {
            return null;
        }
        return this.currentRecipe.getSelectedRecipe();
    }

    public RecipeMemory getMemory() {
        return this.recipeMemory;
    }

    public void chooseRecipeMemory(int recipeIndex) {
        MemorizedRecipe recipe = this.recipeMemory.getRecipe(recipeIndex);
        this.setCurrentRecipe(recipe);
    }

    private void setCraftingDisplay(IInventory craftMatrix) {
        for (int slot = 0; slot < craftMatrix.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, craftMatrix.func_70301_a(slot));
        }
    }

    public IInventory getCraftingDisplay() {
        return new InventoryMapper((IInventory)this.craftingDisplay, 0, 9);
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public void setCurrentRecipe(InventoryCraftingForestry crafting) {
        NonNullList<ItemStack> currentStacks;
        NonNullList<ItemStack> stacks;
        MemorizedRecipe recipe;
        List<IRecipe> recipes = RecipeUtil.findMatchingRecipes(crafting, this.field_145850_b);
        MemorizedRecipe memorizedRecipe = recipe = recipes.isEmpty() ? null : new MemorizedRecipe(crafting, recipes);
        if (this.currentRecipe != null && recipe != null && recipe.hasRecipe(this.currentRecipe.getSelectedRecipe()) && ItemStackUtil.equalSets(stacks = InventoryUtil.getStacks((IInventory)crafting), currentStacks = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix()))) {
            return;
        }
        this.setCurrentRecipe(recipe);
    }

    @Nullable
    public MemorizedRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(@Nullable MemorizedRecipe recipe) {
        this.currentRecipe = recipe;
        if (this.currentRecipe != null) {
            this.setCraftingDisplay((IInventory)this.currentRecipe.getCraftMatrix());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiWorktable(player, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerWorktable(player, this);
    }
}

