/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes;

import forestry.api.recipes.IDescriptiveRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryCraftingForestry;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RecipeUtil {
    public static void addFermenterRecipes(ItemStack resource, int fermentationValue, Fluids output) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, output.getFluid(1), new FluidStack(FluidRegistry.WATER, 1));
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.JUICE.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.JUICE.getFluid(1));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)Fluids.FOR_HONEY.getFluid())) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, output.getFluid(1), Fluids.FOR_HONEY.getFluid(1));
        }
    }

    @Nullable
    public static InventoryCraftingForestry getCraftRecipe(NonNullList<ItemStack> recipeItems, NonNullList<ItemStack> availableItems, World world, IRecipe recipe) {
        if (ItemStackUtil.containsSets(recipeItems, availableItems, true, true) == 0) {
            return null;
        }
        InventoryCraftingForestry crafting = new InventoryCraftingForestry();
        NonNullList<ItemStack> stockCopy = ItemStackUtil.condenseStacks(availableItems);
        block0: for (int slot = 0; slot < recipeItems.size(); ++slot) {
            ItemStack stack;
            ItemStack recipeStack = (ItemStack)recipeItems.get(slot);
            if (recipeStack.func_190926_b()) continue;
            for (ItemStack stockStack : stockCopy) {
                if (stockStack.func_190916_E() <= 0 || !ItemStackUtil.isCraftingEquivalent(recipeStack, stockStack, false, false)) continue;
                stack = ItemStackUtil.createCopyWithCount(stockStack, 1);
                stockStack.func_190918_g(1);
                crafting.func_70299_a(slot, stack);
                break;
            }
            if (!crafting.func_70301_a(slot).func_190926_b()) continue;
            for (ItemStack stockStack : stockCopy) {
                if (stockStack.func_190916_E() <= 0 || !ItemStackUtil.isCraftingEquivalent(recipeStack, stockStack, true, true)) continue;
                stack = ItemStackUtil.createCopyWithCount(stockStack, 1);
                stockStack.func_190918_g(1);
                crafting.func_70299_a(slot, stack);
                continue block0;
            }
        }
        List<IRecipe> outputs = RecipeUtil.findMatchingRecipes(crafting, world);
        if (outputs.contains(recipe)) {
            return crafting;
        }
        return null;
    }

    public static List<IRecipe> findMatchingRecipes(InventoryCrafting inventory, World world) {
        return ForgeRegistries.RECIPES.getValues().stream().filter(recipe -> recipe.func_77569_a(inventory, world)).collect(Collectors.toList());
    }

    public static void addRecipe(String recipeName, Block block, Object ... obj) {
        RecipeUtil.addRecipe(recipeName, new ItemStack(block), obj);
    }

    public static void addRecipe(String recipeName, Item item, Object ... obj) {
        RecipeUtil.addRecipe(recipeName, new ItemStack(item), obj);
    }

    public static void addRecipe(String recipeName, ItemStack itemstack, Object ... obj) {
        ShapedRecipeCustom recipe = new ShapedRecipeCustom(itemstack, obj);
        recipe.setRegistryName("forestry", recipeName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessRecipe(String recipeName, Item item, Object ... obj) {
        RecipeUtil.addShapelessRecipe(recipeName, new ItemStack(item), obj);
    }

    public static void addShapelessRecipe(String recipeName, ItemStack itemstack, Object ... obj) {
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(null, itemstack, obj);
        recipe.setRegistryName("forestry", recipeName);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addSmelting(ItemStack res, Item prod, float xp) {
        RecipeUtil.addSmelting(res, new ItemStack(prod), xp);
    }

    public static void addSmelting(ItemStack res, ItemStack prod, float xp) {
        GameRegistry.addSmelting((ItemStack)res, (ItemStack)prod, (float)xp);
    }

    public static String[][] matches(IDescriptiveRecipe recipe, IInventory inventoryCrafting) {
        NonNullList<NonNullList<ItemStack>> recipeIngredients = recipe.getRawIngredients();
        NonNullList<String> oreDicts = recipe.getOreDicts();
        int width = recipe.getWidth();
        int height = recipe.getHeight();
        return RecipeUtil.matches(recipeIngredients, oreDicts, width, height, inventoryCrafting);
    }

    public static String[][] matches(NonNullList<NonNullList<ItemStack>> recipeIngredients, NonNullList<String> oreDicts, int width, int height, IInventory inventoryCrafting) {
        ItemStack[][] resources = RecipeUtil.getResources(inventoryCrafting);
        return RecipeUtil.matches(recipeIngredients, oreDicts, width, height, resources);
    }

    public static ItemStack[][] getResources(IInventory inventoryCrafting) {
        ItemStack[][] resources = new ItemStack[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i + j * 3;
                resources[i][j] = inventoryCrafting.func_70301_a(k);
            }
        }
        return resources;
    }

    @Nullable
    public static String[][] matches(NonNullList<NonNullList<ItemStack>> recipeIngredients, NonNullList<String> oreDicts, int width, int height, ItemStack[][] resources) {
        for (int i = 0; i <= 3 - width; ++i) {
            for (int j = 0; j <= 3 - height; ++j) {
                String[][] resourceDicts = RecipeUtil.checkMatch(recipeIngredients, oreDicts, width, height, resources, i, j, true);
                if (resourceDicts != null) {
                    return resourceDicts;
                }
                resourceDicts = RecipeUtil.checkMatch(recipeIngredients, oreDicts, width, height, resources, i, j, false);
                if (resourceDicts == null) continue;
                return resourceDicts;
            }
        }
        return null;
    }

    @Nullable
    private static String[][] checkMatch(NonNullList<NonNullList<ItemStack>> recipeIngredients, NonNullList<String> oreDicts, int width, int height, ItemStack[][] resources, int xInGrid, int yInGrid, boolean mirror) {
        String[][] resourceDicts = new String[3][3];
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack resource = resources[k][l];
                int widthIt = k - xInGrid;
                int heightIt = l - yInGrid;
                NonNullList recipeIngredient = null;
                String oreDict = "";
                if (widthIt >= 0 && heightIt >= 0 && widthIt < width && heightIt < height) {
                    int position = mirror ? width - widthIt - 1 + heightIt * width : widthIt + heightIt * width;
                    recipeIngredient = (NonNullList)recipeIngredients.get(position);
                    oreDict = (String)oreDicts.get(position);
                }
                if (!RecipeUtil.checkIngredientMatch(recipeIngredient, resource)) {
                    return null;
                }
                resourceDicts[k][l] = oreDict;
            }
        }
        return resourceDicts;
    }

    private static boolean checkIngredientMatch(@Nullable NonNullList<ItemStack> recipeIngredient, ItemStack resource) {
        if (recipeIngredient == null || recipeIngredient.isEmpty()) {
            return resource.func_190926_b();
        }
        for (ItemStack item : recipeIngredient) {
            if (!ItemStackUtil.isCraftingEquivalent(item, resource)) continue;
            return true;
        }
        return false;
    }
}

