/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming.items;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

import forestry.core.utils.Translator;
import forestry.farming.models.EnumFarmBlockTexture;

public class ItemBlockFarm extends ItemBlock {

	public ItemBlockFarm(Block block) {
		super(block);
		func_77627_a(true);
	}

	@Override
	public int func_77647_b(int i) {
		return i;
	}

	@Override
	public void func_77624_a(ItemStack itemstack, @Nullable World world, List<String> info, ITooltipFlag par4) {
		info.add(Translator.translateToLocal("tile.for.ffarm.tooltip"));
		if (itemstack.func_77978_p() == null) {
			return;
		}
		EnumFarmBlockTexture texture = EnumFarmBlockTexture.getFromCompound(itemstack.func_77978_p());

		info.add(Translator.translateToLocal("tile.for.ffarm.material.tooltip") + texture.getFormatting() + TextFormatting.ITALIC + " "+ texture.getName());
	}

	@Override
	public String func_77667_c(ItemStack itemstack) {
		return super.func_77667_c(itemstack) + "." + itemstack.func_77952_i();
	}
}
