/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHumus
extends Block
implements IItemModelRegister {
    private static final int degradeDelimiter = Config.humusDegradeDelimiter;
    public static final PropertyInteger DEGRADE = PropertyInteger.func_177719_a((String)"degrade", (int)0, (int)degradeDelimiter);

    public BlockHumus() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(CreativeTabForestry.tabForestry);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DEGRADE, (Comparable)Integer.valueOf(0)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DEGRADE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DEGRADE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DEGRADE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DEGRADE);
    }

    public int func_149738_a(World world) {
        return 500;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(Blocks.field_150346_d));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || world.field_73012_v.nextInt(140) != 0) {
            return;
        }
        if (BlockHumus.isEnrooted(world, pos)) {
            BlockHumus.degradeSoil(world, pos);
        }
    }

    private static boolean isEnrooted(World world, BlockPos pos) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos blockPos;
                IBlockState state;
                Block block;
                if (i == 0 && j == 0 || !((block = (state = world.func_180495_p(blockPos = pos.func_177982_a(i, 1, j))).func_177230_c()) instanceof BlockLog) && !(block instanceof IGrowable)) continue;
                return true;
            }
        }
        return false;
    }

    private static void degradeSoil(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        int degrade = (Integer)blockState.func_177229_b((IProperty)DEGRADE);
        if (++degrade >= degradeDelimiter) {
            world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 2);
        } else {
            world.func_180501_a(pos, blockState.func_177226_a((IProperty)DEGRADE, (Comparable)Integer.valueOf(degrade)), 2);
        }
        world.func_175704_b(pos, pos);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos);
        return plantType == EnumPlantType.Crop || plantType == EnumPlantType.Plains;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "soil/humus");
        manager.registerItemModel(item, 1, "soil/humus");
        manager.registerItemModel(item, 2, "soil/humus");
        manager.registerItemModel(item, 3, "soil/humus");
    }
}

