/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.arboriculture.blocks.BlockAbstractLeaves;
import forestry.arboriculture.blocks.PropertyTreeType;
import forestry.arboriculture.genetics.TreeDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockDefaultLeaves
extends BlockAbstractLeaves {
    private static final int VARIANTS_PER_BLOCK = 4;
    private final int blockNumber;

    public static List<BlockDefaultLeaves> create() {
        ArrayList<BlockDefaultLeaves> blocks = new ArrayList<BlockDefaultLeaves>();
        int blockCount = PropertyTreeType.getBlockCount(4);
        for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
            final PropertyTreeType variant = PropertyTreeType.create("variant", blockNumber, 4);
            BlockDefaultLeaves block = new BlockDefaultLeaves(blockNumber){

                @Override
                public PropertyTreeType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public BlockDefaultLeaves(int blockNumber) {
        this.blockNumber = blockNumber;
        PropertyTreeType variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)variant, (Comparable)((Object)variant.getFirstType())).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    protected abstract PropertyTreeType getVariant();

    @Nullable
    public TreeDefinition getTreeDefinition(IBlockState blockState) {
        if (blockState.func_177230_c() == this) {
            return (TreeDefinition)((Object)blockState.func_177229_b((IProperty)this.getVariant()));
        }
        return null;
    }

    public int func_180651_a(IBlockState state) {
        TreeDefinition treeDefinition = this.getTreeDefinition(state);
        if (treeDefinition == null) {
            return 0;
        }
        return treeDefinition.getMetadata() - this.blockNumber * 4;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)this.getTreeType(meta))).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = this.func_180651_a(state);
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant(), field_176236_b, field_176237_a});
    }

    public TreeDefinition getTreeType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.blockNumber * 4;
        return TreeDefinition.byMetadata(variantMeta);
    }

    @Override
    protected void getLeafDrop(NonNullList<ItemStack> drops, World world, @Nullable GameProfile playerProfile, BlockPos pos, float saplingModifier, int fortune) {
        ITree tree = this.getTree((IBlockAccess)world, pos);
        if (tree == null) {
            return;
        }
        List<ITree> saplings = tree.getSaplings(world, playerProfile, pos, saplingModifier);
        for (ITree sapling : saplings) {
            if (sapling == null) continue;
            drops.add((Object)TreeManager.treeRoot.getMemberStack(sapling, EnumGermlingType.SAPLING));
        }
        ITreeGenome genome = tree.getGenome();
        IFruitProvider fruitProvider = genome.getFruitProvider();
        if (fruitProvider.isFruitLeaf(genome, world, pos)) {
            NonNullList<ItemStack> produceStacks = tree.produceStacks(world, pos, Integer.MAX_VALUE);
            drops.addAll(produceStacks);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        TreeDefinition type = this.getTreeType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)type));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IBlockState state : this.field_176227_L.func_177619_a()) {
            int meta = this.func_176201_c(state);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("forestry:leaves.default." + this.blockNumber, "inventory"));
        }
    }

    @Override
    protected ITree getTree(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        TreeDefinition treeDefinition = this.getTreeDefinition(blockState);
        if (treeDefinition != null) {
            return treeDefinition.getIndividual();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        TreeDefinition treeDefinition = this.getTreeDefinition(state);
        if (treeDefinition == null) {
            treeDefinition = TreeDefinition.Oak;
        }
        ITreeGenome genome = treeDefinition.getGenome();
        if (tintIndex == 0) {
            return genome.getPrimary().getLeafSpriteProvider().getColor(false);
        }
        IFruitProvider fruitProvider = genome.getFruitProvider();
        return fruitProvider.getDecorativeColor();
    }
}

