/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import com.google.common.collect.ImmutableMap;
import forestry.api.arboriculture.IWoodType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.client.model.IModel;

public enum WoodBlockKind {
    LOG,
    PLANKS,
    SLAB,
    FENCE,
    FENCE_GATE,
    STAIRS,
    DOOR;


    public String getName() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.getName();
    }

    public IModel retextureModel(IModel model, IWoodType type, ImmutableMap<String, String> customTextures) {
        HashMap<String, String> textures = new HashMap<String, String>();
        switch (this) {
            case SLAB: 
            case STAIRS: {
                String textureLocation = type.getPlankTexture();
                textures.put("particle", textureLocation);
                textures.put("side", textureLocation);
                textures.put("top", textureLocation);
                textures.put("bottom", textureLocation);
                textures.put("all", textureLocation);
                break;
            }
            case PLANKS: {
                textures.put("particle", type.getPlankTexture());
                textures.put("all", type.getPlankTexture());
                break;
            }
            case FENCE_GATE: 
            case FENCE: {
                textures.put("particle", type.getPlankTexture());
                textures.put("side", type.getPlankTexture());
                textures.put("texture", type.getPlankTexture());
                break;
            }
            case DOOR: {
                textures.put("particle", type.getDoorLowerTexture());
                textures.put("bottom", type.getDoorLowerTexture());
                textures.put("top", type.getDoorUpperTexture());
                break;
            }
            case LOG: {
                textures.put("particle", type.getBarkTexture());
                textures.put("side", type.getBarkTexture());
                textures.put("all", type.getBarkTexture());
                textures.put("end", type.getHeartTexture());
                break;
            }
        }
        textures.putAll((Map<String, String>)customTextures);
        return model.retexture(new ImmutableMap.Builder().putAll(textures).build());
    }
}

