/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.entities;

import javax.annotation.Nullable;

import net.minecraft.util.math.BlockPos;

public abstract class AIButterflyInteract extends AIButterflyBase {
	@Nullable
	protected BlockPos rest;

	private boolean canInteract = false;
	private boolean hasInteracted = false;

	protected AIButterflyInteract(EntityButterfly entity) {
		super(entity);
		func_75248_a(3);
	}

	@Override
	public boolean func_75250_a() {
		if (entity.getState() != EnumButterflyState.RESTING) {
			return false;
		}

		rest = new BlockPos((int) entity.field_70165_t, (int) Math.floor(entity.field_70163_u) - 1, (int) entity.field_70161_v);
		if (entity.field_70170_p.func_175623_d(rest)) {
			return false;
		}

		canInteract = canInteract();

		return canInteract;
	}

	protected abstract boolean canInteract();

	@Override
	public boolean func_75253_b() {
		return canInteract && !hasInteracted;
	}

	@Override
	public void func_75249_e() {
	}

	@Override
	public void func_75251_c() {
		canInteract = false;
		hasInteracted = false;
		rest = null;
	}

	protected void setHasInteracted() {
		hasInteracted = true;
	}

}
