package forestry.core.render;

import com.google.common.collect.Maps;

import java.io.IOException;
import java.util.Map;

import org.apache.commons.io.IOUtils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.core.utils.Log;

@SideOnly(Side.CLIENT)
public class TextureMapForestry extends TextureMap {
	public TextureMapForestry(String basePathIn) {
		super(basePathIn, null, true);
	}

	@Override
	public void func_110551_a(IResourceManager resourceManager) throws IOException {
		this.func_110569_e();
		this.func_147631_c();
		this.func_110571_b(resourceManager);
	}

	@Override
	public void func_110571_b(IResourceManager resourceManager) {
		int i = Minecraft.func_71369_N();
		Stitcher stitcher = new Stitcher(i, i, 0, 0);
		this.field_94252_e.clear();
		this.field_94258_i.clear();

		ProgressManager.ProgressBar bar = ProgressManager.push("Texture stitching", this.field_110574_e.size());
		
		for (Map.Entry<String, TextureAtlasSprite> entry : this.field_110574_e.entrySet()) {
			TextureAtlasSprite textureatlassprite = entry.getValue();
			ResourceLocation resourcelocation = this.getResourceLocation(textureatlassprite);
			bar.step(resourcelocation.func_110623_a());
			IResource iresource = null;

			if (textureatlassprite.hasCustomLoader(resourceManager, resourcelocation)) {
				if (textureatlassprite.load(resourceManager, resourcelocation, l -> field_110574_e.get(l.toString()))) {
					continue;
				}
			} else
				try {
					PngSizeInfo pngsizeinfo = PngSizeInfo.func_188532_a(resourceManager.func_110536_a(resourcelocation));
					iresource = resourceManager.func_110536_a(resourcelocation);
					boolean flag = iresource.func_110526_a("animation") != null;
					textureatlassprite.func_188538_a(pngsizeinfo, flag);
				} catch (RuntimeException runtimeexception) {
					FMLClientHandler.instance().trackBrokenTexture(resourcelocation, runtimeexception.getMessage());
					continue;
				} catch (IOException ioexception) {
					FMLClientHandler.instance().trackMissingTexture(resourcelocation);
					continue;
				} finally {
					IOUtils.closeQuietly(iresource);
				}

			stitcher.func_110934_a(textureatlassprite);
		}
		
		ProgressManager.pop(bar);

		this.field_94249_f.func_147963_d(0);
		stitcher.func_110934_a(this.field_94249_f);
		bar = ProgressManager.push("Texture creation", 2);

		bar.step("Stitching");
		stitcher.func_94305_f();

		Log.info("Created: {}x{} {}-atlas", stitcher.func_110935_a(), stitcher.func_110936_b(), this.field_94254_c);
		bar.step("Allocating GL texture");
		TextureUtil.func_180600_a(this.func_110552_b(), 0, stitcher.func_110935_a(), stitcher.func_110936_b());
		Map<String, TextureAtlasSprite> map = Maps.newHashMap(this.field_110574_e);

		ProgressManager.pop(bar);
		bar = ProgressManager.push("Texture mipmap and upload", stitcher.func_94309_g().size());

		for (TextureAtlasSprite textureatlassprite1 : stitcher.func_94309_g()) {
			bar.step(textureatlassprite1.func_94215_i());
			if (textureatlassprite1 == this.field_94249_f || this.generateMipmaps(resourceManager, textureatlassprite1)) {
				String s = textureatlassprite1.func_94215_i();
				map.remove(s);
				this.field_94252_e.put(s, textureatlassprite1);

				try {
					TextureUtil.func_147955_a(textureatlassprite1.func_147965_a(0), textureatlassprite1.func_94211_a(), textureatlassprite1.func_94216_b(), textureatlassprite1.func_130010_a(), textureatlassprite1.func_110967_i(), false, false);
				} catch (Throwable throwable) {
					CrashReport crashreport = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
					CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
					crashreportcategory.func_71507_a("Atlas path", this.field_94254_c);
					crashreportcategory.func_71507_a("Sprite", textureatlassprite1);
					throw new ReportedException(crashreport);
				}

				if (textureatlassprite1.func_130098_m()) {
					this.field_94258_i.add(textureatlassprite1);
				}
			}
		}

		for (TextureAtlasSprite textureatlassprite2 : map.values()) {
			textureatlassprite2.func_94217_a(this.field_94249_f);
		}

		ProgressManager.pop(bar);
	}

	private boolean generateMipmaps(IResourceManager resourceManager, final TextureAtlasSprite texture) {
		ResourceLocation resourcelocation = this.getResourceLocation(texture);
		IResource iresource = null;
		label9:
		{
			boolean flag;
			if (texture.hasCustomLoader(resourceManager, resourcelocation)) break label9;
			try {
				iresource = resourceManager.func_110536_a(resourcelocation);
				texture.func_188539_a(iresource, 1);
				break label9;
			} catch (RuntimeException runtimeexception) {
				Log.error("Unable to parse metadata from {}", resourcelocation, runtimeexception);
				flag = false;
			} catch (IOException ioexception) {
				Log.error("Using missing texture, unable to load {}", resourcelocation, ioexception);
				flag = false;
				return flag;
			} finally {
				IOUtils.closeQuietly(iresource);
			}

			return flag;
		}

		try {
			texture.func_147963_d(0);
			return true;
		} catch (Throwable throwable) {
			CrashReport crashreport = CrashReport.func_85055_a(throwable, "Applying mipmap");
			CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
			crashreportcategory.func_189529_a("Sprite name", texture::func_94215_i);
			crashreportcategory.func_189529_a("Sprite size", () -> texture.func_94211_a() + " x " + texture.func_94216_b());
			crashreportcategory.func_189529_a("Sprite frames", () -> texture.func_110970_k() + " frames");
			crashreportcategory.func_71507_a("Mipmap levels", 0);
			throw new ReportedException(crashreport);
		}
	}

	private ResourceLocation getResourceLocation(TextureAtlasSprite p_184396_1_) {
		ResourceLocation resourcelocation = new ResourceLocation(p_184396_1_.func_94215_i());
		return new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, resourcelocation.func_110623_a(), ".png"));
	}
}
