/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import forestry.Forestry;
import forestry.api.core.ForestryAPI;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.PluginCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.ForestryPluginUtil;
import forestry.plugins.IForestryPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class PluginManager {
    private static final String PLUGIN_CONFIG_FILE_NAME = "plugins.cfg";
    private static final String CATEGORY_PLUGINS = "plugins";
    public static final ArrayList<IPickupHandler> pickupHandlers = Lists.newArrayList();
    public static final ArrayList<ISaveEventHandler> saveEventHandlers = Lists.newArrayList();
    public static final ArrayList<IResupplyHandler> resupplyHandlers = Lists.newArrayList();
    private static final Set<IForestryPlugin> loadedPlugins = new LinkedHashSet<IForestryPlugin>();
    private static final Set<IForestryPlugin> unloadedPlugins = new LinkedHashSet<IForestryPlugin>();
    private static Stage stage = Stage.SETUP;
    public static final Set<IForestryPlugin> configDisabledPlugins = new HashSet<IForestryPlugin>();

    public static Stage getStage() {
        return stage;
    }

    public static Set<IForestryPlugin> getLoadedPlugins() {
        return ImmutableSet.copyOf(loadedPlugins);
    }

    private static void registerHandlers(IForestryPlugin plugin, Side side) {
        IFuelHandler fuelHandler;
        IResupplyHandler resupplyHandler;
        ISaveEventHandler saveHandler;
        IPickupHandler pickupHandler;
        Log.debug("Registering Handlers for Plugin: {}", plugin);
        IPacketRegistry packetRegistry = plugin.getPacketRegistry();
        if (packetRegistry != null) {
            packetRegistry.registerPacketsServer();
            if (side == Side.CLIENT) {
                packetRegistry.registerPacketsClient();
            }
        }
        if ((pickupHandler = plugin.getPickupHandler()) != null) {
            pickupHandlers.add(pickupHandler);
        }
        if ((saveHandler = plugin.getSaveEventHandler()) != null) {
            saveEventHandlers.add(saveHandler);
        }
        if ((resupplyHandler = plugin.getResupplyHandler()) != null) {
            resupplyHandlers.add(resupplyHandler);
        }
        if ((fuelHandler = plugin.getFuelHandler()) != null) {
            GameRegistry.registerFuelHandler((IFuelHandler)fuelHandler);
        }
    }

    private static IForestryPlugin getPluginCore(List<IForestryPlugin> forestryPlugins) {
        for (IForestryPlugin plugin : forestryPlugins) {
            if (!(plugin instanceof PluginCore)) continue;
            return plugin;
        }
        throw new IllegalStateException("Could not find core plugin");
    }

    private static void configurePlugins(List<IForestryPlugin> forestryPlugins) {
        ForestryPlugin info;
        boolean changed;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Configuration config = new Configuration(new File(Forestry.instance.getConfigFolder(), PLUGIN_CONFIG_FILE_NAME));
        config.load();
        config.addCustomCategoryComment(CATEGORY_PLUGINS, "Disabling these plugins can greatly change how the mod functions.\nYour mileage may vary, please report any issues.");
        IForestryPlugin corePlugin = PluginManager.getPluginCore(forestryPlugins);
        forestryPlugins.remove(corePlugin);
        forestryPlugins.add(0, corePlugin);
        HashSet<String> toLoad = new HashSet<String>();
        ImmutableList allForestryPlugins = ImmutableList.copyOf(forestryPlugins);
        Iterator<IForestryPlugin> iterator = forestryPlugins.iterator();
        while (iterator.hasNext()) {
            IForestryPlugin plugin = iterator.next();
            if (plugin.canBeDisabled()) {
                if (!PluginManager.isEnabled(config, plugin)) {
                    iterator.remove();
                    Log.info("Plugin disabled: {}", plugin);
                    continue;
                }
                if (!plugin.isAvailable()) {
                    iterator.remove();
                    Log.info("Plugin {} failed to load: {}", plugin, plugin.getFailMessage());
                    continue;
                }
            }
            ForestryPlugin info2 = plugin.getClass().getAnnotation(ForestryPlugin.class);
            toLoad.add(info2.pluginID());
        }
        do {
            changed = false;
            iterator = forestryPlugins.iterator();
            while (iterator.hasNext()) {
                IForestryPlugin plugin = iterator.next();
                Set<String> dependencies = plugin.getDependencyUids();
                if (toLoad.containsAll(dependencies)) continue;
                iterator.remove();
                changed = true;
                info = plugin.getClass().getAnnotation(ForestryPlugin.class);
                String pluginId = info.pluginID();
                toLoad.remove(pluginId);
                Log.warning("Plugin {} is missing dependencies: {}", pluginId, dependencies);
            }
        } while (changed);
        loadedPlugins.addAll(forestryPlugins);
        unloadedPlugins.addAll((Collection<IForestryPlugin>)allForestryPlugins);
        unloadedPlugins.removeAll(loadedPlugins);
        ForestryAPI.enabledPlugins = new HashSet<String>();
        for (IForestryPlugin plugin : loadedPlugins) {
            info = plugin.getClass().getAnnotation(ForestryPlugin.class);
            ForestryAPI.enabledPlugins.add(info.pluginID());
        }
        if (config.hasChanged()) {
            config.save();
        }
        Locale.setDefault(locale);
    }

    public static void runSetup(FMLPreInitializationEvent event) {
        ASMDataTable asmDataTable = event.getAsmData();
        List<IForestryPlugin> forestryPlugins = ForestryPluginUtil.getForestryPlugins(asmDataTable);
        stage = Stage.SETUP;
        PluginManager.configurePlugins(forestryPlugins);
        for (IForestryPlugin plugin : loadedPlugins) {
            Log.debug("Setup API Start: {}", plugin);
            plugin.setupAPI();
            Log.debug("Setup API Complete: {}", plugin);
        }
        stage = Stage.SETUP_DISABLED;
        for (IForestryPlugin plugin : unloadedPlugins) {
            Log.debug("Disabled-Setup Start: {}", plugin);
            plugin.disabledSetupAPI();
            Log.debug("Disabled-Setup Complete: {}", plugin);
        }
        stage = Stage.REGISTER;
        for (IForestryPlugin plugin : loadedPlugins) {
            Log.debug("Register Items and Blocks Start: {}", plugin);
            plugin.registerItemsAndBlocks();
            Log.debug("Register Items and Blocks Complete: {}", plugin);
        }
    }

    public static void runPreInit(Side side) {
        stage = Stage.PRE_INIT;
        for (IForestryPlugin plugin : loadedPlugins) {
            Log.debug("Pre-Init Start: {}", plugin);
            PluginManager.registerHandlers(plugin, side);
            plugin.preInit();
            if (ForestryAPI.enabledPlugins.contains("forestry.buildcraft.statements")) {
                plugin.registerTriggers();
            }
            if (ForestryAPI.enabledPlugins.contains("forestry.storage")) {
                plugin.registerBackpackItems();
                plugin.registerCrates();
            }
            Log.debug("Pre-Init Complete: {}", plugin);
        }
    }

    public static void runInit() {
        stage = Stage.INIT;
        for (IForestryPlugin plugin : loadedPlugins) {
            Log.debug("Init Start: {}", plugin);
            plugin.doInit();
            plugin.registerRecipes();
            Log.debug("Init Complete: {}", plugin);
        }
    }

    public static void runPostInit() {
        stage = Stage.POST_INIT;
        for (IForestryPlugin plugin : loadedPlugins) {
            Log.debug("Post-Init Start: {}", plugin);
            plugin.postInit();
            Log.debug("Post-Init Complete: {}", plugin);
        }
        stage = Stage.FINISHED;
    }

    public static void serverStarting(MinecraftServer server) {
        CommandHandler commandManager = (CommandHandler)server.func_71187_D();
        for (IForestryPlugin plugin : loadedPlugins) {
            ICommand[] commands = plugin.getConsoleCommands();
            if (commands == null) continue;
            for (ICommand command : commands) {
                commandManager.func_71560_a(command);
            }
        }
    }

    public static void processIMCMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            for (IForestryPlugin plugin : loadedPlugins) {
                if (plugin.processIMCMessage(message)) break;
            }
        }
    }

    public static void populateChunk(IChunkGenerator chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        for (IForestryPlugin plugin : loadedPlugins) {
            plugin.populateChunk(chunkProvider, world, rand, chunkX, chunkZ, hasVillageGenerated);
        }
    }

    public static void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        for (IForestryPlugin plugin : loadedPlugins) {
            plugin.populateChunkRetroGen(world, rand, chunkX, chunkZ);
        }
    }

    public static List<ItemStack> getHiddenItems() {
        ArrayList<ItemStack> hiddenItems = new ArrayList<ItemStack>();
        for (IForestryPlugin plugin : loadedPlugins) {
            plugin.getHiddenItems(hiddenItems);
        }
        return hiddenItems;
    }

    public static Set<String> getLootPoolNames() {
        HashSet<String> lootPoolNames = new HashSet<String>();
        for (IForestryPlugin plugin : loadedPlugins) {
            plugin.addLootPoolNames(lootPoolNames);
        }
        return lootPoolNames;
    }

    private static boolean isEnabled(Configuration config, IForestryPlugin plugin) {
        ForestryPlugin info = plugin.getClass().getAnnotation(ForestryPlugin.class);
        String comment = Translator.translateToLocal(info.unlocalizedDescription());
        Property prop = config.get(CATEGORY_PLUGINS, info.pluginID(), true, comment);
        boolean enabled = prop.getBoolean();
        if (!enabled) {
            configDisabledPlugins.add(plugin);
        }
        return enabled;
    }

    public static enum Stage {
        SETUP,
        SETUP_DISABLED,
        REGISTER,
        PRE_INIT,
        INIT,
        POST_INIT,
        FINISHED;

    }
}

