package forestry.arboriculture.render;

import java.util.LinkedHashMap;
import java.util.Map;

import com.google.common.collect.Maps;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.blocks.BlockSapling;
import forestry.core.render.ForestryStateMapper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class SaplingStateMapper extends ForestryStateMapper {

	@Override
	public Map<IBlockState, ModelResourceLocation> func_178130_a(Block block) {
		for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
			if (allele instanceof IAlleleTreeSpecies) {
				IAlleleTreeSpecies tree = (IAlleleTreeSpecies) allele;
				IBlockState state = block.func_176223_P().func_177226_a(BlockSapling.TREE, tree);
				LinkedHashMap<IProperty<?>, Comparable<?>> linkedhashmap = Maps.newLinkedHashMap(state.func_177228_b());
				String modID = tree.getModID();
				String s = String.format("%s:%s", modID, "germlings");
				mapStateModelLocations.put(state, new ModelResourceLocation(s, getPropertyString(linkedhashmap)));
			}
		}
		return mapStateModelLocations;
	}

}
