/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.core.PluginCore;
import forestry.core.blocks.BlockResourceOre;
import forestry.core.blocks.EnumResourceType;
import forestry.core.config.Config;
import forestry.plugins.PluginManager;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenerator
implements IWorldGenerator {
    @Nullable
    private WorldGenMinable apatiteGenerator;
    @Nullable
    private WorldGenMinable copperGenerator;
    @Nullable
    private WorldGenMinable tinGenerator;

    public WorldGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world);
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Post event) {
        PluginManager.populateChunk(event.getGen(), event.getWorld(), event.getRand(), event.getChunkX(), event.getChunkZ(), event.isHasVillageGenerated());
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateWorld(random, chunkX, chunkZ, world);
        PluginManager.populateChunkRetroGen(world, random, chunkX, chunkZ);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    private void generateWorld(Random random, int chunkX, int chunkZ, World world) {
        int randPosZ;
        int randPosY;
        if (this.apatiteGenerator == null || this.copperGenerator == null || this.tinGenerator == null) {
            BlockResourceOre resourcesBlock = PluginCore.getBlocks().resources;
            IBlockState apatiteBlockState = resourcesBlock.func_176203_a(EnumResourceType.APATITE.getMeta());
            IBlockState copperBlockState = resourcesBlock.func_176203_a(EnumResourceType.COPPER.getMeta());
            IBlockState tinBlockState = resourcesBlock.func_176203_a(EnumResourceType.TIN.getMeta());
            this.apatiteGenerator = new WorldGenMinable(apatiteBlockState, 36);
            this.copperGenerator = new WorldGenMinable(copperBlockState, 6);
            this.tinGenerator = new WorldGenMinable(tinBlockState, 6);
        }
        int x = chunkX << 4;
        int y = chunkZ << 4;
        if (Config.generateApatiteOre && random.nextFloat() < 0.8f) {
            int randPosX = x + random.nextInt(16);
            int randPosY2 = random.nextInt(world.func_72940_L() - 72) + 56;
            int randPosZ2 = y + random.nextInt(16);
            this.apatiteGenerator.func_180709_b(world, random, new BlockPos(randPosX, randPosY2, randPosZ2));
        }
        if (Config.generateCopperOre) {
            for (int i = 0; i < 20; ++i) {
                int randPosX = x + random.nextInt(16);
                randPosY = random.nextInt(76) + 32;
                randPosZ = y + random.nextInt(16);
                this.copperGenerator.func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
            }
        }
        if (Config.generateTinOre) {
            for (int i = 0; i < 18; ++i) {
                int randPosX = x + random.nextInt(16);
                randPosY = random.nextInt(76) + 16;
                randPosZ = y + random.nextInt(16);
                this.tinGenerator.func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
            }
        }
    }
}

