/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.utils.BlockUtil;
import forestry.farming.logic.Crop;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropBasicAgriCraft
extends Crop {
    private final IBlockState blockState;

    public CropBasicAgriCraft(World world, IBlockState blockState, BlockPos position) {
        super(world, position);
        this.blockState = blockState;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        Block block = this.blockState.func_177230_c();
        NonNullList harvest = NonNullList.func_191196_a();
        harvest.addAll((Collection)block.getDrops((IBlockAccess)world, pos, this.blockState, 0));
        if (harvest.size() > 1) {
            harvest.remove(1);
        }
        harvest.remove(0);
        IBlockState oldState = world.func_180495_p(pos);
        BlockUtil.setBlockWithBreakSound(world, pos, block.func_176223_P(), oldState);
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicAgriCraft [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

