/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.compat;

import com.google.common.base.Preconditions;
import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.genetics.Genome;
import forestry.core.utils.JeiUtil;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.item.Item;

@JEIPlugin
public class ApicultureJeiPlugin
extends BlankModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        ItemRegistryApiculture items = PluginApiculture.getItems();
        Preconditions.checkNotNull((Object)items);
        ISubtypeRegistry.ISubtypeInterpreter beeSubtypeInterpreter = itemStack -> {
            IAlleleSpecies species = Genome.getSpeciesDirectly(BeeManager.beeRoot, itemStack);
            return species == null ? null : species.getUID();
        };
        subtypeRegistry.registerSubtypeInterpreter((Item)items.beeDroneGE, beeSubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter((Item)items.beePrincessGE, beeSubtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter((Item)items.beeQueenGE, beeSubtypeInterpreter);
    }

    public void register(IModRegistry registry) {
        ItemRegistryApiculture items = PluginApiculture.getItems();
        Preconditions.checkNotNull((Object)items);
        JeiUtil.addDescription(registry, "frames", items.frameImpregnated, items.frameProven, items.frameUntreated);
        JeiUtil.addDescription(registry, "apiarist.suit", new Item[]{items.apiaristBoots, items.apiaristChest, items.apiaristHat, items.apiaristLegs});
        JeiUtil.addDescription(registry, items.habitatLocator, items.scoop, items.imprinter);
    }
}

