/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.entities.EntityMinecartBeehouse;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMinecartBeehouse
extends ItemMinecart
implements IItemModelRegister {
    private final String[] definition = new String[]{"cart.beehouse", "cart.apiary"};
    private static final IBehaviorDispenseItem dispenserMinecartBehavior = (source, stack) -> stack;

    public ItemMinecartBeehouse() {
        super(EntityMinecart.Type.CHEST);
        this.func_77656_e(0);
        this.func_77627_a(true);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)dispenserMinecartBehavior);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!BlockRailBase.func_176563_d((IBlockState)worldIn.func_180495_p(pos))) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            EntityMinecartBeeHousingBase entityMinecart = stack.func_77952_i() == 0 ? new EntityMinecartBeehouse(worldIn, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f) : new EntityMinecartApiary(worldIn, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
            entityMinecart.getOwnerHandler().setOwner(player.func_146103_bH());
            if (stack.func_82837_s()) {
                entityMinecart.func_96094_a(stack.func_82833_r());
            }
            worldIn.func_72838_d((Entity)entityMinecart);
        }
        stack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() >= this.definition.length || stack.func_77952_i() < 0) {
            return "item.forestry.unknown";
        }
        return "item.for." + this.definition[stack.func_77952_i()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (int i = 0; i < this.definition.length; ++i) {
            manager.registerItemModel(item, i, this.definition[i]);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < this.definition.length; ++i) {
            subItems.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public ItemStack getBeeHouseMinecart() {
        return new ItemStack((Item)this, 1, 0);
    }

    public ItemStack getApiaryMinecart() {
        return new ItemStack((Item)this, 1, 1);
    }
}

