/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.gui.slots;

import com.google.common.collect.Lists;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

import forestry.factory.tiles.ICrafterWorktable;

public class SlotCrafter extends Slot {

	/**
	 * The craft matrix inventory linked to this result slot.
	 */
	private final IInventory craftMatrix;
	private final ICrafterWorktable crafter;

	/**
	 * The player that is using the GUI where this slot resides.
	 */
	private final EntityPlayer player;
	/**
	 * The number of items that have been crafted so far. Gets passed to ItemStack.onCrafting before being reset.
	 */
	private int amountCrafted;

	public SlotCrafter(EntityPlayer player, IInventory craftMatrix, ICrafterWorktable crafter, int slot, int xPos, int yPos) {
		super(craftMatrix, slot, xPos, yPos);
		this.craftMatrix = craftMatrix;
		this.crafter = crafter;
		this.player = player;
	}

	/**
	 * Check if the stack is a valid item for this slot. Always true beside for the armor slots.
	 */
	@Override
	public boolean func_75214_a(ItemStack stack) {
		return false;
	}

	/**
	 * the itemStack passed in is the output - ie, iron ingots, and pickaxes, not ore and wood. Typically increases an
	 * internal count then calls onCrafting(item).
	 */
	@Override
	protected void func_75210_a(ItemStack stack, int amount) {
		this.amountCrafted += amount;
		this.func_75208_c(stack);
	}

	/**
	 * Copied from {@link SlotCrafting#onCrafting(ItemStack)}
	 */
	@Override
	protected void func_75208_c(ItemStack stack) {
		if (this.amountCrafted > 0) {
			stack.func_77980_a(this.player.field_70170_p, this.player, this.amountCrafted);
			net.minecraftforge.fml.common.FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, stack, craftMatrix);
		}
		
		this.amountCrafted = 0;
		InventoryCraftResult inventorycraftresult = (InventoryCraftResult) this.field_75224_c;
		IRecipe irecipe = inventorycraftresult.func_193055_i();
		
		if (irecipe != null && !irecipe.func_192399_d()) {
			this.player.func_192021_a(Lists.newArrayList(irecipe));
			inventorycraftresult.func_193056_a(null);
		}
	}

	@Override
	public ItemStack func_75209_a(int amount) {
		if (!this.func_75216_d()) {
			return ItemStack.field_190927_a;
		}

		return this.func_75211_c();
	}

	@Override
	public boolean func_82869_a(EntityPlayer player) {
		return crafter.canTakeStack(getSlotIndex());
	}

	@Override
	public ItemStack func_75211_c() {
		return crafter.getResult();
	}

	@Override
	public boolean func_75216_d() {
		return !func_75211_c().func_190926_b() && crafter.canTakeStack(getSlotIndex());
	}

	@Override
	public ItemStack func_190901_a(EntityPlayer player, ItemStack itemStack) {
		if (crafter.onCraftingStart(player)) {
			this.func_75208_c(itemStack); // handles crafting achievements, maps, and statistics

			crafter.onCraftingComplete(player);
		}
		return itemStack;
	}
}
