/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.gui;

import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.ElementEvent;
import forestry.climatology.gui.ContainerHabitatFormer;
import forestry.climatology.gui.elements.ClimateBarElement;
import forestry.climatology.gui.elements.HabitatSelectionElement;
import forestry.climatology.gui.elements.SpeciesSelectionElement;
import forestry.climatology.network.packets.PacketSelectClimateTargeted;
import forestry.climatology.tiles.TileHabitatFormer;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.elements.ButtonElement;
import forestry.core.gui.elements.ScrollBarElement;
import forestry.core.gui.elements.TextEditElement;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiHabitatFormer
extends GuiForestryTitled<ContainerHabitatFormer>
implements IScrollable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/habitat_former.png");
    private static final Drawable TEMPERATURE_FIELD = new Drawable(TEXTURE, 204, 22, 52, 12);
    private static final Drawable HUMIDITY_FIELD = new Drawable(TEXTURE, 204, 34, 52, 12);
    private static final Drawable SCROLLBAR_SLIDER = new Drawable(TEXTURE, 176, 92, 12, 15);
    private static final Drawable CIRCLE_ENABLED_BUTTON = new Drawable(TEXTURE, 238, 110, 18, 18);
    private static final Drawable CIRCLE_DISABLED_BUTTON = new Drawable(TEXTURE, 220, 110, 18, 18);
    private final TileHabitatFormer tile;
    private final IClimateTransformer transformer;
    private final ElementGroup selectionPage;
    private final ScrollBarElement rangeBar;
    private TextEditElement temperatureEdit;
    private TextEditElement humidityEdit;

    public GuiHabitatFormer(EntityPlayer player, TileHabitatFormer tile) {
        super("textures/gui/habitat_former.png", new ContainerHabitatFormer(player.field_71071_by, tile), tile);
        this.transformer = tile.getTransformer();
        this.tile = tile;
        this.field_147000_g = 233;
        this.widgetManager.add(new TankWidget(this.widgetManager, 152, 17, 0));
        this.window.add(new ClimateBarElement(61, 33, this.transformer, ClimateType.TEMPERATURE));
        this.window.add(new ClimateBarElement(61, 57, this.transformer, ClimateType.HUMIDITY));
        this.rangeBar = this.window.add(new ScrollBarElement(10, 17, 12, 58, SCROLLBAR_SLIDER)).setParameters(this, 1, 16, 1);
        this.rangeBar.addTooltip((tooltip, element, mouseX, mouseY) -> {
            tooltip.add(Translator.translateToLocal("for.gui.habitat_former.climate.range"));
            tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted("for.gui.habitat_former.climate.range.blocks", this.rangeBar.getValue()));
        });
        this.window.add(new CircleButton(30, 37));
        this.selectionPage = this.window.pane(8, 86, 164, 56);
        this.selectionPage.add(new SpeciesSelectionElement(135, 22, this.transformer));
        this.selectionPage.label(Translator.translateToLocal("for.gui.habitat_former.climate.habitats"), GuiElementAlignment.TOP_CENTER).setLocation(17, 3);
        this.selectionPage.add(new HabitatSelectionElement(67, 12, this.transformer));
        this.selectionPage.label(Translator.translateToLocal("for.gui.habitat_former.climate.temperature"), GuiElementAlignment.TOP_CENTER).setLocation(-49, 5);
        this.selectionPage.drawable(7, 15, TEMPERATURE_FIELD);
        this.temperatureEdit = this.selectionPage.add(new TextEditElement(9, 17, 50, 10).setMaxLength(3));
        this.temperatureEdit.addSelfEventHandler(ElementEvent.LoseFocus.class, event -> this.setClimate(ClimateType.TEMPERATURE, this.temperatureEdit.getValue()));
        this.selectionPage.drawable(7, 39, HUMIDITY_FIELD);
        this.selectionPage.label(Translator.translateToLocal("for.gui.habitat_former.climate.humidity"), GuiElementAlignment.TOP_CENTER).setLocation(-49, 30);
        this.humidityEdit = this.selectionPage.add(new TextEditElement(9, 41, 50, 10).setMaxLength(3));
        this.humidityEdit.addSelfEventHandler(ElementEvent.LoseFocus.class, event -> this.setClimate(ClimateType.HUMIDITY, this.humidityEdit.getValue()));
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        IClimateState target = this.transformer.getTarget();
        if (this.humidityEdit != null && !this.window.isFocused(this.humidityEdit)) {
            this.humidityEdit.setValue(Integer.toString((int)(MathHelper.func_76131_a((float)target.getHumidity(), (float)0.0f, (float)2.0f) * 100.0f)));
        }
        if (this.temperatureEdit != null && !this.window.isFocused(this.temperatureEdit)) {
            this.temperatureEdit.setValue(Integer.toString((int)(MathHelper.func_76131_a((float)target.getTemperature(), (float)0.0f, (float)2.0f) * 100.0f)));
        }
        if (this.rangeBar.getValue() != this.transformer.getRange()) {
            this.updateRange();
        }
    }

    private void updateRange() {
        this.rangeBar.setValue(this.transformer.getRange());
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        this.drawCenteredString(Translator.translateToLocal("for.gui.habitat_former.climate.temperature"), this.field_146999_f / 2, 23);
        this.drawCenteredString(Translator.translateToLocal("for.gui.habitat_former.climate.humidity"), this.field_146999_f / 2, 47);
    }

    private void drawCenteredString(String text, int x, int y) {
        this.field_146289_q.func_175063_a(text, (float)this.field_147003_i + (float)((double)x - (double)this.field_146289_q.func_78256_a(text) / 2.0), (float)this.field_147009_r + (float)y, 0xFFFFFF);
    }

    public void setClimate(ClimateType type, String text) {
        int value;
        try {
            value = Integer.parseInt(text);
        }
        catch (NumberFormatException exception) {
            value = 0;
        }
        float climateValue = MathHelper.func_76131_a((float)((float)value / 100.0f), (float)0.0f, (float)2.0f);
        IClimateState target = this.transformer.getTarget();
        this.setClimate(target.setClimate(type, climateValue));
        this.sendClimateUpdate();
    }

    public void setClimate(IClimateState state) {
        this.transformer.setTarget(state.copy());
    }

    public void sendClimateUpdate() {
        IClimateState targetedState = this.transformer.getTarget();
        if (targetedState.isPresent()) {
            BlockPos pos = this.tile.func_174877_v();
            NetworkUtil.sendToServer(new PacketSelectClimateTargeted(pos, targetedState));
        }
    }

    public IClimateState getClimate() {
        return this.transformer.getTarget();
    }

    @Override
    protected void addLedgers() {
        this.addClimateLedger(this.tile);
        this.addErrorLedger(this.tile);
        this.addPowerLedger(this.tile.getEnergyManager());
        this.addHintLedger("habitat_former");
    }

    @Override
    public void onScroll(int value) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(1, value));
        this.transformer.setRange(value);
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.rangeBar.isMouseOver();
    }

    private class CircleButton
    extends ButtonElement {
        private CircleButton(int xPos, int yPos) {
            super(xPos, yPos, 18, 18, CIRCLE_DISABLED_BUTTON, CIRCLE_ENABLED_BUTTON, button -> ((CircleButton)button).onButtonPressed());
            this.addTooltip((Collection<String> tooltip, IGuiElement element, int mouseX, int mouseY) -> tooltip.add(Translator.translateToLocal("for.gui.habitat_former.climate.circle." + (GuiHabitatFormer.this.transformer.isCircular() ? "enabled" : "disabled"))));
        }

        private void onButtonPressed() {
            GuiHabitatFormer.this.transformer.setCircular(!GuiHabitatFormer.this.transformer.isCircular());
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(0, GuiHabitatFormer.this.transformer.isCircular() ? 1 : 0));
        }

        @Override
        protected int getHoverState(boolean mouseOver) {
            return GuiHabitatFormer.this.transformer.isCircular() ? 1 : 0;
        }
    }
}

