/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.items;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.entities.EntityMinecartBeehouse;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;


import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.entities.EntityMinecartBeehouse;

public class ItemMinecartBeehouse extends ItemMinecart implements IItemModelRegister {
	private final String[] definition = new String[]{"cart.beehouse", "cart.apiary"};

	private static final IBehaviorDispenseItem dispenserMinecartBehavior = (source, stack) -> stack;

	public ItemMinecartBeehouse() {
		super(EntityMinecart.Type.CHEST);
		func_77656_e(0);
		func_77627_a(true);
		BlockDispenser.field_149943_a.func_82595_a(this, dispenserMinecartBehavior);
	}

	@Override
	public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if (!BlockRailBase.func_176563_d(worldIn.func_180495_p(pos))) {
			return EnumActionResult.PASS;
		}

		ItemStack stack = player.func_184586_b(hand);

		if (!worldIn.field_72995_K) {
			EntityMinecartBeeHousingBase entityMinecart;

			if (stack.func_77952_i() == 0) {
				entityMinecart = new EntityMinecartBeehouse(worldIn, pos.func_177958_n() + 0.5F, pos.func_177956_o() + 0.5F, pos.func_177952_p() + 0.5F);
			} else {
				entityMinecart = new EntityMinecartApiary(worldIn, pos.func_177958_n() + 0.5F, pos.func_177956_o() + 0.5F, pos.func_177952_p() + 0.5F);
			}

			entityMinecart.getOwnerHandler().setOwner(player.func_146103_bH());

			if (stack.func_82837_s()) {
				entityMinecart.func_96094_a(stack.func_82833_r());
			}

			worldIn.func_72838_d(entityMinecart);
		}

		stack.func_190918_g(1);
		return EnumActionResult.SUCCESS;
	}

	@Override
	public String func_77667_c(ItemStack stack) {
		if (stack.func_77952_i() >= definition.length || stack.func_77952_i() < 0) {
			return "item.forestry.unknown";
		} else {
			return "item.for." + definition[stack.func_77952_i()];
		}
	}

	/* MODELS */
	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < definition.length; i++) {
			manager.registerItemModel(item, i, definition[i]);
		}
	}

	@Override
	public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
		if (this.func_194125_a(tab)) {
			for (int i = 0; i < definition.length; i++) {
				subItems.add(new ItemStack(this, 1, i));
			}
		}
	}

	public ItemStack getBeeHouseMinecart() {
		return new ItemStack(this, 1, 0);
	}

	public ItemStack getApiaryMinecart() {
		return new ItemStack(this, 1, 1);
	}
}
