/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.farming.logic.crops.CropBasicAgriCraft;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FarmableBasicAgricraft
implements IFarmable {
    private final Block cropBlock;
    @Nullable
    private final Method matureMethod;
    private final Item seedItem;

    public FarmableBasicAgricraft(Block cropBlock, Item seedItem) {
        Method method;
        this.cropBlock = cropBlock;
        this.seedItem = seedItem;
        Class<?> cropClass = cropBlock.getClass();
        try {
            method = ReflectionHelper.findMethod(cropClass, (String)"isMature", null, (Class[])new Class[]{World.class, BlockPos.class});
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            method = null;
        }
        this.matureMethod = method;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_177230_c() == this.cropBlock;
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return itemstack.func_77973_b() == this.seedItem;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        if (!this.isMature(world, pos)) {
            return null;
        }
        return new CropBasicAgriCraft(world, blockState, pos);
    }

    @Override
    public void addInformation(IFarmableInfo info) {
        NonNullList stacks = NonNullList.func_191196_a();
        this.seedItem.func_150895_a(CreativeTabs.field_78027_g, stacks);
        info.addGermlings((Collection<ItemStack>)stacks);
    }

    private boolean isMature(World world, BlockPos pos) {
        if (this.matureMethod == null) {
            return false;
        }
        try {
            return (Boolean)this.matureMethod.invoke((Object)this.cropBlock, world, pos);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }
}

