/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.arboriculture.blocks.BlockAsh;
import forestry.arboriculture.blocks.BlockCharcoal;
import forestry.arboriculture.blocks.BlockDecorativeWoodPile;
import forestry.arboriculture.blocks.BlockLoam;
import forestry.arboriculture.blocks.BlockWoodPile;
import forestry.core.blocks.BlockRegistry;
import forestry.core.items.ItemBlockForestry;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlockRegistryCharcoal
extends BlockRegistry {
    public final BlockCharcoal charcoal;
    public final BlockWoodPile woodPile;
    public final BlockDecorativeWoodPile woodPileDecorative;
    public final BlockAsh[] ash = new BlockAsh[4];
    public final Block loam;

    public BlockRegistryCharcoal() {
        this.charcoal = new BlockCharcoal();
        ItemBlockForestry<BlockCharcoal> itemBlockCharcoal = new ItemBlockForestry<BlockCharcoal>(this.charcoal){

            public int getItemBurnTime(ItemStack itemStack) {
                return 16000;
            }
        };
        this.registerBlock(this.charcoal, itemBlockCharcoal, "charcoal");
        OreDictionary.registerOre((String)"blockCharcoal", (Item)itemBlockCharcoal);
        this.woodPile = new BlockWoodPile();
        ItemBlockForestry<BlockWoodPile> itemBlockWoodPile = new ItemBlockForestry<BlockWoodPile>(this.woodPile){

            public int getItemBurnTime(ItemStack itemStack) {
                return 1200;
            }
        };
        this.registerBlock(this.woodPile, itemBlockWoodPile, "wood_pile");
        this.woodPileDecorative = new BlockDecorativeWoodPile();
        ItemBlockForestry<BlockDecorativeWoodPile> itemBlockWoodPileDecorative = new ItemBlockForestry<BlockDecorativeWoodPile>(this.woodPileDecorative){

            public int getItemBurnTime(ItemStack itemStack) {
                return 1200;
            }
        };
        this.registerBlock(this.woodPileDecorative, itemBlockWoodPileDecorative, "wood_pile_decorative");
        for (int i = 0; i < 4; ++i) {
            BlockAsh ashBlock;
            this.ash[i] = ashBlock = new BlockAsh(i * 16);
            this.registerBlock(ashBlock, new ItemBlockForestry<BlockAsh>(ashBlock), "ash_block_" + i);
        }
        this.loam = new BlockLoam();
        this.registerBlock(this.loam, new ItemBlockForestry<Block>(this.loam), "loam");
    }

    public IBlockState getAshState(int amount) {
        if (amount > 63) {
            amount = 63;
        }
        int i = amount / 16;
        return this.ash[i].func_176223_P().func_177226_a((IProperty)BlockAsh.AMOUNT, (Comparable)Integer.valueOf(amount % 16));
    }
}

