/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.centrifuge;

import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryTooltipCallback;
import forestry.core.render.ForestryResource;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeWrapper;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CentrifugeRecipeCategory
extends ForestryRecipeCategory<CentrifugeRecipeWrapper> {
    private static final int[][] OUTPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    private static final Comparator<Map.Entry<ItemStack, Float>> highestChanceComparator = (o1, o2) -> ((Float)o2.getValue()).compareTo((Float)o1.getValue());
    private static final int inputSlot = 0;
    private static final int outputSlot = 1;
    private static final ResourceLocation guiTexture = new ForestryResource("textures/gui/centrifugesocket2.png");
    private final IDrawableAnimated arrow;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 11, 18, 154, 54), "tile.for.centrifuge.name");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 0, 4, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public String getUid() {
        return "forestry.centrifuge";
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 32, 18);
        this.arrow.draw(minecraft, 56, 18);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CentrifugeRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 4, 18);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        guiItemStacks.set(0, (List)inputs.get(0));
        ForestryTooltipCallback tooltip = new ForestryTooltipCallback();
        Map<ItemStack, Float> products = ((ICentrifugeRecipe)recipeWrapper.getRecipe()).getAllProducts();
        CentrifugeRecipeCategory.setResults(tooltip, products, guiItemStacks);
        guiItemStacks.addTooltipCallback((ITooltipCallback)tooltip);
    }

    private static void setResults(ForestryTooltipCallback tooltip, Map<ItemStack, Float> outputs, IGuiItemStackGroup guiItemStacks) {
        Set<Map.Entry<ItemStack, Float>> entrySet = outputs.entrySet();
        if (entrySet.isEmpty()) {
            return;
        }
        PriorityQueue<Map.Entry<ItemStack, Float>> sortByChance = new PriorityQueue<Map.Entry<ItemStack, Float>>(entrySet.size(), highestChanceComparator);
        sortByChance.addAll(entrySet);
        int i = 0;
        while (!sortByChance.isEmpty()) {
            Map.Entry stack = (Map.Entry)sortByChance.poll();
            if (i >= OUTPUTS.length) {
                return;
            }
            int x = 100 + OUTPUTS[i][0] * 18;
            int y = OUTPUTS[i][1] * 18;
            int slotIndex = 1 + i;
            guiItemStacks.init(slotIndex, false, x, y);
            guiItemStacks.set(slotIndex, (ItemStack)stack.getKey());
            tooltip.addChanceTooltip(slotIndex, ((Float)stack.getValue()).floatValue());
            ++i;
        }
    }
}

