package forestry.core.multiblock;

import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;

import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Log;

@SideOnly(Side.CLIENT)
public class MultiblockEventHandlerClient {

	@SubscribeEvent
	public void onGameOverlay(RenderGameOverlayEvent.Post event) {
		if (GeneticsUtil.hasNaturalistEye(Minecraft.func_71410_x().field_71439_g)) {
			if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && Minecraft.func_71410_x().field_71462_r == null) {
				Minecraft minecraft = Minecraft.func_71410_x();
				RayTraceResult posHit = minecraft.field_71476_x;
				ScaledResolution resolution = event.getResolution();

				if (posHit != null && posHit.func_178782_a() != null) {
					TileUtil.actOnTile(minecraft.field_71441_e, posHit.func_178782_a(), IMultiblockComponent.class, component -> {
						IMultiblockController controller = component.getMultiblockLogic().getController();
						String lastValidationError = controller.getLastValidationError();
						if (lastValidationError != null) {
							lastValidationError = TextFormatting.DARK_RED.toString() + TextFormatting.ITALIC.toString() + lastValidationError;
							minecraft.field_71466_p.func_78279_b(lastValidationError, resolution.func_78326_a() / 2 + 35, resolution.func_78328_b() / 2 - 25, 128, 16777215);
						}
					});
				}
			}
		}
	}

	@SubscribeEvent
	public void onWorldRenderLast(RenderWorldLastEvent event) {
		if (GeneticsUtil.hasNaturalistEye(Minecraft.func_71410_x().field_71439_g)) {
			try {
				World world = Minecraft.func_71410_x().field_71441_e;
				Set<IMultiblockControllerInternal> controllers = MultiblockRegistry.getControllersFromWorld(world);
				if (!controllers.isEmpty()) {
					float partialTicks = event.getPartialTicks();
					EntityPlayer player = Minecraft.func_71410_x().field_71439_g;
					double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
					double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
					double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;

					GlStateManager.func_179094_E();
					GlStateManager.func_179147_l();
					GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
					GlStateManager.func_179090_x();
					GlStateManager.func_187441_d(2.0F);
					GlStateManager.func_179132_a(false);
					for (IMultiblockController controller : controllers) {
						if (controller != null) {
							BlockPos lastErrorPosition = controller.getLastValidationErrorPosition();
							if (lastErrorPosition != null) {
								if (world.func_175667_e(lastErrorPosition) && player.func_174818_b(lastErrorPosition) < 64F) {
									AxisAlignedBB box = Block.field_185505_j.func_72317_d(lastErrorPosition.func_177958_n() - playerX, lastErrorPosition.func_177956_o() - playerY, lastErrorPosition.func_177952_p() - playerZ);
									RenderGlobal.func_189697_a(box, 1.0F, 0.0F, 0.0F, 0.25F);
									RenderGlobal.func_189696_b(box, 1.0F, 0.0F, 0.0F, 0.125F);
								}
							}
						}
					}

					GlStateManager.func_179132_a(true);
					GlStateManager.func_179098_w();
					GlStateManager.func_179084_k();
					GlStateManager.func_179121_F();
				}
			} catch (Exception e) {
				Log.error("Failed to render the position of a multiblock exception.", e);
			}
		}
	}
}
