/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.arboriculture.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;

public class PacketRipeningUpdate extends ForestryPacket implements IForestryPacketClient {
	private final BlockPos pos;
	private final int value;

	public PacketRipeningUpdate(TileLeaves leaves) {
		this.pos = leaves.func_174877_v();
		this.value = leaves.getFruitColour();
	}

	@Override
	public PacketIdClient getPacketId() {
		return PacketIdClient.RIPENING_UPDATE;
	}

	@Override
	protected void writeData(PacketBufferForestry data) {
		data.func_179255_a(pos);
		data.func_150787_b(value);
	}

	@SideOnly(Side.CLIENT)
	public static class Handler implements IForestryPacketHandlerClient {
		@Override
		public void onPacketData(PacketBufferForestry data, EntityPlayer player) {
			BlockPos pos = data.func_179259_c();
			int value = data.func_150792_a();

			TileUtil.actOnTile(player.field_70170_p, pos, IRipeningPacketReceiver.class, tile -> tile.fromRipeningPacket(value));
		}
	}
}
