/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.apiculture.genetics.BeeGenome;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SubCommand;
import forestry.lepidopterology.genetics.ButterflyGenome;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class CommandListAlleles
extends SubCommand {
    public CommandListAlleles() {
        super("listAlleles");
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)sender.func_70005_c_());
        ItemStack stack = player.func_184614_ca();
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(stack);
        if (individual == null) {
            return;
        }
        Enum[] types = null;
        IGenome genome = individual.getGenome();
        if (genome instanceof BeeGenome) {
            types = EnumBeeChromosome.values();
        } else if (genome instanceof TreeGenome) {
            types = EnumTreeChromosome.values();
        } else if (genome instanceof ButterflyGenome) {
            types = EnumButterflyChromosome.values();
        }
        if (types == null) {
            return;
        }
        for (Enum type : types) {
            CommandHelpers.sendChatMessage(sender, type.getName() + ": " + genome.getActiveAllele((IChromosomeType)((Object)type)).getAlleleName() + " " + genome.getInactiveAllele((IChromosomeType)((Object)type)).getAlleleName());
        }
    }
}

