/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.blocks;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.utils.Translator;

public class BlockClimatiser extends Block implements IBlockWithMeta, IItemModelRegister {
	public static final PropertyEnum<BlockClimatiserType> TYPE = PropertyEnum.func_177709_a("type", BlockClimatiserType.class);

	public BlockClimatiser() {
		super(Material.field_151592_s);

		func_149711_c(1f);
		setHarvestLevel("pickaxe", 0);
		this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, BlockClimatiserType.HUMIDIFIER));
	}

	@Override
	public String getNameFromMeta(int meta) {
		BlockClimatiserType type = BlockClimatiserType.VALUES[meta];
		return type.func_176610_l();
	}

	@SuppressWarnings("deprecation")
	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(TYPE, BlockClimatiserType.VALUES[meta]);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(TYPE).ordinal();
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@Override
	public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
		for (int i = 0; i < BlockClimatiserType.VALUES.length; i++) {
			list.add(new ItemStack(this, 1, i));
		}
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, TYPE);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
		tooltip.add(TextFormatting.RED.toString() + Translator.translateToLocal("tile.for.greenhouse.deprecated1"));
		tooltip.add(TextFormatting.RED.toString() + Translator.translateToLocal("tile.for.greenhouse.deprecated2"));
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (int i = 0; i < BlockClimatiserType.VALUES.length; i++) {
			ModelLoader.setCustomModelResourceLocation(item, i, new ModelResourceLocation("forestry:greenhouse/" + BlockClimatiserType.VALUES[i].func_176610_l(), "inventory"));
		}
	}
}
