/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.mail.ILetter;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemWithGui;
import forestry.core.utils.SlotUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.items.ItemStamps;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemInventoryLetter
extends ItemInventory
implements IErrorSource {
    private final ILetter letter;

    public ItemInventoryLetter(EntityPlayer player, ItemStack itemstack) {
        super(player, 0, itemstack);
        NBTTagCompound tagCompound = itemstack.func_77978_p();
        Preconditions.checkNotNull((Object)tagCompound);
        this.letter = new Letter(tagCompound);
    }

    public ILetter getLetter() {
        return this.letter;
    }

    public void onLetterClosed() {
        ItemStack parent = this.getParent();
        LetterProperties.closeLetter(parent, this.letter);
    }

    public void onLetterOpened() {
        ItemStack parent = this.getParent();
        LetterProperties.openLetter(parent);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack result = this.letter.func_70298_a(index, count);
        NBTTagCompound tagCompound = this.getParent().func_77978_p();
        Preconditions.checkNotNull((Object)tagCompound);
        this.letter.writeToNBT(tagCompound);
        return result;
    }

    @Override
    public void func_70299_a(int index, ItemStack itemstack) {
        this.letter.func_70299_a(index, itemstack);
        NBTTagCompound tagCompound = this.getParent().func_77978_p();
        Preconditions.checkNotNull((Object)tagCompound);
        this.letter.writeToNBT(tagCompound);
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.letter.func_70301_a(i);
    }

    @Override
    public int func_70302_i_() {
        return this.letter.func_70302_i_();
    }

    @Override
    public String func_70005_c_() {
        return this.letter.func_70005_c_();
    }

    @Override
    public int func_70297_j_() {
        return this.letter.func_70297_j_();
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.letter.func_70300_a(entityplayer);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return this.letter.func_70304_b(slot);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (this.letter.isProcessed()) {
            return false;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 18, 4)) {
            Item item = itemStack.func_77973_b();
            return item instanceof ItemStamps;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 18)) {
            return !(itemStack.func_77973_b() instanceof ItemWithGui);
        }
        return false;
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.letter.hasRecipient()) {
            errorStates.add((Object)EnumErrorCode.NO_RECIPIENT);
        }
        if (!this.letter.isProcessed() && !this.letter.isPostPaid()) {
            errorStates.add((Object)EnumErrorCode.NOT_POST_PAID);
        }
        return errorStates.build();
    }
}

