/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.core.commands.ICommandModeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.World;

public class BeeModeHelper
implements ICommandModeHelper {
    @Override
    public String[] getModeNames() {
        List<IBeekeepingMode> beekeepingModes = BeeManager.beeRoot.getBeekeepingModes();
        int modeStringCount = beekeepingModes.size();
        ArrayList<String> modeStrings = new ArrayList<String>(modeStringCount);
        for (IBeekeepingMode mode : beekeepingModes) {
            modeStrings.add(mode.getName());
        }
        return modeStrings.toArray(new String[modeStringCount]);
    }

    @Override
    public String getModeName(World world) {
        return BeeManager.beeRoot.getBeekeepingMode(world).getName();
    }

    @Override
    public boolean setMode(World world, String modeName) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(modeName);
        if (mode != null) {
            BeeManager.beeRoot.setBeekeepingMode(world, mode);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<String> getDescription(String modeName) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(modeName);
        if (mode == null) {
            return Collections.emptyList();
        }
        return mode.getDescription();
    }
}

