package forestry.sorting.blocks;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.blocks.BlockForestry;
import forestry.core.gui.GuiHandler;
import forestry.core.tiles.TileUtil;
import forestry.sorting.tiles.TileGeneticFilter;

public class BlockGeneticFilter extends BlockForestry implements IItemModelRegister {
	public static final PropertyBool NORTH = PropertyBool.func_177716_a("north");
	public static final PropertyBool EAST = PropertyBool.func_177716_a("east");
	public static final PropertyBool SOUTH = PropertyBool.func_177716_a("south");
	public static final PropertyBool WEST = PropertyBool.func_177716_a("west");
	public static final PropertyBool UP = PropertyBool.func_177716_a("up");
	public static final PropertyBool DOWN = PropertyBool.func_177716_a("down");

	private static final AxisAlignedBB BOX_CENTER = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
	private static final AxisAlignedBB BOX_DOWN = new AxisAlignedBB(0.25, 0, 0.25, 0.75, 0.3125, 0.75);
	private static final AxisAlignedBB BOX_UP = new AxisAlignedBB(0.25, 0.6875, 0.25, 0.75, 1, 0.75);
	private static final AxisAlignedBB BOX_NORTH = new AxisAlignedBB(0.25, 0.25, 0, 0.75, 0.75, 0.3125);
	private static final AxisAlignedBB BOX_SOUTH = new AxisAlignedBB(0.25, 0.25, 0.6875, 0.75, 0.75, 1);
	private static final AxisAlignedBB BOX_WEST = new AxisAlignedBB(0, 0.25, 0.25, 0.3125, 0.75, 0.75);
	private static final AxisAlignedBB BOX_EAST = new AxisAlignedBB(0.6875, 0.25, 0.25, 1, 0.75, 0.75);
	private static final AxisAlignedBB[] BOX_FACES = {BOX_DOWN, BOX_UP, BOX_NORTH, BOX_SOUTH, BOX_WEST, BOX_EAST};

	public BlockGeneticFilter() {
		super(Material.field_151575_d);
		func_149647_a(CreativeTabForestry.tabForestry);
		this.func_180632_j(this.field_176227_L.func_177621_b()
			.func_177226_a(NORTH, false)
			.func_177226_a(EAST, false)
			.func_177226_a(SOUTH, false)
			.func_177226_a(WEST, false)
			.func_177226_a(UP, false)
			.func_177226_a(DOWN, false));
		func_149713_g(0);
		func_149711_c(0.25f);
		func_149752_b(3.0f);
	}

	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
		TileGeneticFilter geneticFilter = TileUtil.getTile(worldIn, pos, TileGeneticFilter.class);
		if (geneticFilter == null) {
			return func_176223_P();
		}
		return state.func_177226_a(NORTH, geneticFilter.isConnected(EnumFacing.NORTH))
			.func_177226_a(EAST, geneticFilter.isConnected(EnumFacing.EAST))
			.func_177226_a(SOUTH, geneticFilter.isConnected(EnumFacing.SOUTH))
			.func_177226_a(WEST, geneticFilter.isConnected(EnumFacing.WEST))
			.func_177226_a(UP, geneticFilter.isConnected(EnumFacing.UP))
			.func_177226_a(DOWN, geneticFilter.isConnected(EnumFacing.DOWN));
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		TileGeneticFilter tile = TileUtil.getTile(worldIn, pos, TileGeneticFilter.class);
		if (tile != null) {
			if (TileUtil.isUsableByPlayer(playerIn, tile)) {
				if (!worldIn.field_72995_K) {
					GuiHandler.openGui(playerIn, tile);
				}
				return true;
			}
		}
		return false;
	}

	@Nullable
	@Override
	public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
		RayTraceResult result = func_185503_a(pos, start, end, BOX_CENTER);
		if (result != null) {
			result.subHit = 0;
			return result;
		}
		TileGeneticFilter geneticFilter = TileUtil.getTile(worldIn, pos, TileGeneticFilter.class);
		if (geneticFilter != null) {
			for (EnumFacing facing : EnumFacing.field_82609_l) {
				if (geneticFilter.isConnected(facing)) {
					result = func_185503_a(pos, start, end, BOX_FACES[facing.ordinal()]);
					if (result != null) {
						result.subHit = 1 + facing.ordinal();
						return result;
					}
				}
			}
		}
		return null;
	}

	@Override
	public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
		func_185492_a(pos, entityBox, collidingBoxes, BOX_CENTER);
		TileGeneticFilter geneticFilter = TileUtil.getTile(worldIn, pos, TileGeneticFilter.class);
		if (geneticFilter != null) {
			for (EnumFacing facing : EnumFacing.field_82609_l) {
				if (geneticFilter.isConnected(facing)) {
					func_185492_a(pos, entityBox, collidingBoxes, BOX_FACES[facing.ordinal()]);
				}
			}
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
		RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
		if (trace == null || trace.subHit < 0 || !pos.equals(trace.func_178782_a())) {
			return field_185505_j.func_186670_a(pos);
		}
		AxisAlignedBB aabb = field_185505_j;
		int sub = trace.subHit;
		if (sub == 0) {
			aabb = BOX_CENTER;
		} else if (sub < 1 + 6) {
			aabb = BOX_FACES[sub - 1];
		}
		return aabb.func_186670_a(pos);
	}

	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, NORTH, EAST, SOUTH, WEST, UP, DOWN);
	}

	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		return new TileGeneticFilter();
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return 0;
	}

	@Override
	public boolean func_149686_d(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149730_j(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}
}
