package forestry.core.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import net.minecraftforge.common.util.JsonUtils;

public class JsonUtil {
	private JsonUtil() {
	}

	public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback) {
		return deserializeItemStack(object, fallback, false);
	}

	public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback, boolean logError) {
		if (!object.has("item")) {
			if (logError) {
				Log.error("Unsupported icon type, currently only items are supported (add 'item' key)");
			}
			return fallback;
		}
		try {
			Item item = net.minecraft.util.JsonUtils.func_188180_i(object, "item");
			int meta = net.minecraft.util.JsonUtils.func_151208_a(object, "data", 0);
			ItemStack stack = new ItemStack(item, 1, meta);
			stack.func_77982_d(JsonUtils.readNBT(object, "nbt"));
			return stack;
		} catch (JsonSyntaxException e) {
			if (logError) {
				Log.trace("Filed to parse item.", e);
			}
			return fallback;
		}
	}
}
