package forestry.cultivation.gui.widgets;

import javax.annotation.Nullable;
import java.util.Locale;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import forestry.api.farming.FarmDirection;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import forestry.cultivation.inventory.InventoryPlanter;

public class GhostItemStackWidget extends ItemStackWidget {
	private final Slot slot;

	public GhostItemStackWidget(WidgetManager widgetManager, int xPos, int yPos, ItemStack itemStack, Slot slot) {
		super(widgetManager, xPos, yPos, itemStack);
		this.slot = slot;
	}

	@Override
	public void draw(int startX, int startY) {
		if (!slot.func_75216_d()) {
			super.draw(startX, startY);
		}
		GlStateManager.func_179140_f();
		GlStateManager.func_179097_i();
		GlStateManager.func_179147_l();

		String directionString = getDirectionString();
		if (!directionString.isEmpty()) {
			FontRenderer fontRenderer = manager.minecraft.field_71466_p;
			fontRenderer.func_175063_a(getDirectionString(), xPos + startX + 5, yPos + startY + 4, ColourProperties.INSTANCE.get("gui.screen"));
		}

		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 0.5F);

		TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
		textureManager.func_110577_a(manager.gui.textureFile);
		manager.gui.func_73729_b(xPos + startX, yPos + startY, 206, 0, 16, 16);

		GlStateManager.func_179084_k();
		GlStateManager.func_179126_j();
		GlStateManager.func_179145_e();
	}

	private String getDirectionString() {
		if (slot.getSlotIndex() >= InventoryPlanter.SLOT_PRODUCTION_1 || slot.getSlotIndex() < InventoryPlanter.SLOT_RESOURCES_1 + InventoryPlanter.SLOT_RESOURCES_COUNT) {
			return "";
		}
		int index = slot.getSlotIndex() % 4;
		FarmDirection direction = FarmDirection.values()[index];
		String directionString = direction.toString().toLowerCase(Locale.ENGLISH);
		return Translator.translateToLocal("for.gui.planter." + directionString);
	}

	@Nullable
	@Override
	public ToolTip getToolTip(int mouseX, int mouseY) {
		return null;
	}
}
