package forestry.core.gui;

import java.io.IOException;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;

import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.api.gui.events.GuiEventDestination;
import forestry.core.gui.elements.Window;

import org.lwjgl.input.Mouse;

/**
 * GuiScreen implementation of a gui that contains {@link forestry.api.gui.IGuiElement}s.
 */
public class GuiWindow extends GuiScreen implements IGuiSizable {
	protected final Window window;
	protected final int xSize;
	protected final int ySize;
	protected int guiLeft;
	protected int guiTop;

	public GuiWindow(int xSize, int ySize) {
		this.xSize = xSize;
		this.ySize = ySize;
		this.window = new Window<>(xSize, ySize, this);
		addElements();
	}

	protected void addElements() {
	}

	@Override
	public boolean func_73868_f() {
		return false;
	}

	@Override
	public void func_73876_c() {
		window.updateClient();
	}

	@Override
	public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
		window.setMousePosition(mouseX, mouseY);
		super.func_73863_a(mouseX, mouseY, partialTicks);
		window.draw(mouseX, mouseY);
	}

	protected void drawTooltips(int mouseX, int mouseY) {
		InventoryPlayer playerInv = field_146297_k.field_71439_g.field_71071_by;

		if (playerInv.func_70445_o().func_190926_b()) {
			GuiUtil.drawToolTips(this, field_146292_n, mouseX, mouseY);
			GlStateManager.func_179094_E();
			GlStateManager.func_179109_b(guiLeft, guiTop, 0.0F);
			window.drawTooltip(mouseX, mouseY);
			GlStateManager.func_179121_F();
		}
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.guiLeft = (this.field_146294_l - xSize) / 2;
		this.guiTop = (this.field_146295_m - ySize) / 2;
		window.init(guiLeft, guiTop);
	}

	@Override
	public void func_146280_a(Minecraft mc, int width, int height) {
		window.setSize(width, height);
		super.func_146280_a(mc, width, height);
	}

	@Override
	protected void func_73869_a(char typedChar, int keyCode) {
		if (keyCode == 1) {
			this.field_146297_k.func_147108_a(null);

			if (this.field_146297_k.field_71462_r == null) {
				this.field_146297_k.func_71381_h();
			}
		}
		IGuiElement origin = (window.getFocusedElement() == null) ? this.window : this.window.getFocusedElement();
		window.postEvent(new GuiEvent.KeyEvent(origin, typedChar, keyCode), GuiEventDestination.ALL);
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
		super.func_73864_a(mouseX, mouseY, mouseButton);
		IGuiElement origin = (window.getMousedOverElement() == null) ? this.window : this.window.getMousedOverElement();
		window.postEvent(new GuiEvent.DownEvent(origin, mouseX, mouseY, mouseButton), GuiEventDestination.ALL);
	}

	@Override
	protected void func_146286_b(int mouseX, int mouseY, int state) {
		super.func_146286_b(mouseX, mouseY, state);
		IGuiElement origin = (window.getMousedOverElement() == null) ? this.window : this.window.getMousedOverElement();
		window.postEvent(new GuiEvent.UpEvent(origin, mouseX, mouseY, state), GuiEventDestination.ALL);
	}

	@Override
	public void func_146274_d() throws IOException {
		super.func_146274_d();
		int dWheel = Mouse.getDWheel();
		if (dWheel != 0) {
			window.postEvent(new GuiEvent.WheelEvent(window, dWheel), GuiEventDestination.ALL);
		}
	}

	@Override
	public int getGuiLeft() {
		return guiLeft;
	}

	@Override
	public int getGuiTop() {
		return guiTop;
	}

	@Override
	public int getSizeX() {
		return xSize;
	}

	@Override
	public int getSizeY() {
		return ySize;
	}

	@Override
	public Minecraft getMC() {
		return field_146297_k;
	}

}
