/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui;

import forestry.api.genetics.IFilterLogic;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.SlotGeneticFilter;
import forestry.sorting.gui.widgets.RuleWidget;
import forestry.sorting.gui.widgets.SelectionWidget;
import forestry.sorting.gui.widgets.SpeciesWidget;
import forestry.sorting.tiles.IFilterContainer;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class GuiGeneticFilter
extends GuiForestryTitled<ContainerGeneticFilter> {
    private final IFilterContainer tile;
    private final WidgetScrollBar scrollBar;
    public final SelectionWidget selection;
    @Nullable
    private GuiTextField searchField;

    public GuiGeneticFilter(IFilterContainer tile, InventoryPlayer inventory) {
        super("textures/gui/filter.png", new ContainerGeneticFilter(tile, inventory), tile);
        int i;
        this.field_147000_g = 222;
        this.field_146999_f = 212;
        this.tile = tile;
        for (i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            this.widgetManager.add(new RuleWidget(this.widgetManager, 44, 18 + i * 18, facing, this));
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.widgetManager.add(new SpeciesWidget(this.widgetManager, 80 + j * 45 + k * 18, 18 + i * 18, EnumFacing.func_82600_a((int)i), j, k == 0, this));
                }
            }
        }
        this.scrollBar = new WidgetScrollBar(this.widgetManager, 193, 150, 12, 64, new Drawable(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"), 232, 0, 12, 15));
        this.selection = new SelectionWidget(this.widgetManager, 0, 134, this.scrollBar, this);
        this.widgetManager.add(this.selection);
        this.widgetManager.add(this.scrollBar);
        this.scrollBar.setVisible(false);
    }

    public <S> void onModuleClick(ISelectableProvider<S> provider) {
        if (this.selection.isSame(provider)) {
            this.deselectFilter();
        } else {
            this.selectFilter(provider);
        }
    }

    private <S> void selectFilter(ISelectableProvider<S> provider) {
        this.selection.setProvider(provider);
        if (this.searchField != null) {
            this.searchField.func_146184_c(true);
            this.searchField.func_146189_e(true);
        }
        this.selection.filterEntries(this.searchField != null ? this.searchField.func_146179_b() : "");
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof SlotGeneticFilter)) continue;
            SlotGeneticFilter filter = (SlotGeneticFilter)slot;
            filter.setEnabled(false);
        }
    }

    private void deselectFilter() {
        this.selection.setProvider(null);
        if (this.searchField != null) {
            this.searchField.func_146184_c(false);
            this.searchField.func_146189_e(false);
        }
        this.scrollBar.setVisible(false);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof SlotGeneticFilter)) continue;
            SlotGeneticFilter filter = (SlotGeneticFilter)slot;
            filter.setEnabled(true);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String oldString = this.searchField != null ? this.searchField.func_146179_b() : "";
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + this.selection.getX() + 89 + 36, this.selection.getY() + this.field_147009_r + 4, 80, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146180_a(oldString);
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField != null && this.searchField.func_146201_a(typedChar, keyCode)) {
            this.scrollBar.setValue(0);
            this.selection.filterEntries(this.searchField.func_146179_b());
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    @Nullable
    protected Slot func_146975_c(int mouseX, int mouseY) {
        Slot slot = super.func_146975_c(mouseX, mouseY);
        if (slot instanceof SlotGeneticFilter && this.selection.getLogic() != null) {
            return null;
        }
        return slot;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        Widget widget;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.searchField != null) {
            this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if ((widget = this.widgetManager.getAtPosition(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) == null) {
            this.deselectFilter();
        }
    }

    @Override
    protected void addLedgers() {
        this.addHintLedger("filter");
    }

    public IFilterContainer getContainer() {
        return this.tile;
    }

    public IFilterLogic getLogic() {
        return this.tile.getLogic();
    }
}

