/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.inventory;

import com.google.common.collect.ImmutableSet;

import java.util.Set;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.core.errors.EnumErrorCode;
import forestry.core.inventory.ItemInventory;

public class ItemInventoryHabitatLocator extends ItemInventory implements IErrorSource {

	private static final short SLOT_ENERGY = 2;
	private static final short SLOT_SPECIMEN = 0;
	private static final short SLOT_ANALYZED = 1;

	private final HabitatLocatorLogic locatorLogic;

	public ItemInventoryHabitatLocator(EntityPlayer player, ItemStack itemstack) {
		super(player, 3, itemstack);
		ItemHabitatLocator habitatLocator = (ItemHabitatLocator) itemstack.func_77973_b();
		this.locatorLogic = habitatLocator.getLocatorLogic();
	}

	private static boolean isEnergy(ItemStack itemstack) {
		if (itemstack.func_190926_b()) {
			return false;
		}

		Item item = itemstack.func_77973_b();
		return ModuleApiculture.getItems().honeyDrop == item || ModuleApiculture.getItems().honeydew == item;
	}

	@Override
	public void onSlotClick(int slotIndex, EntityPlayer player) {
		if (!func_70301_a(SLOT_ANALYZED).func_190926_b()) {
			if (locatorLogic.isBiomeFound()) {
				return;
			}
		} else if (!func_70301_a(SLOT_SPECIMEN).func_190926_b()) {
			// Requires energy
			if (!isEnergy(func_70301_a(SLOT_ENERGY))) {
				return;
			}

			// Decrease energy
			func_70298_a(SLOT_ENERGY, 1);

			func_70299_a(SLOT_ANALYZED, func_70301_a(SLOT_SPECIMEN));
			func_70299_a(SLOT_SPECIMEN, ItemStack.field_190927_a);
		}

		ItemStack analyzed = func_70301_a(SLOT_ANALYZED);
		IBee bee = BeeManager.beeRoot.getMember(analyzed);
		if (bee != null) {
			locatorLogic.startBiomeSearch(bee, player);
		}
	}

	public Set<Biome> getBiomesToSearch() {
		return locatorLogic.getTargetBiomes();
	}

	/* IErrorSource */
	@Override
	public ImmutableSet<IErrorState> getErrorStates() {
		if (!func_70301_a(SLOT_ANALYZED).func_190926_b()) {
			return ImmutableSet.of();
		}

		ImmutableSet.Builder<IErrorState> errorStates = ImmutableSet.builder();

		ItemStack specimen = func_70301_a(SLOT_SPECIMEN);
		if (!BeeManager.beeRoot.isMember(specimen)) {
			errorStates.add(EnumErrorCode.NO_SPECIMEN);
		}

		if (!isEnergy(func_70301_a(SLOT_ENERGY))) {
			errorStates.add(EnumErrorCode.NO_HONEY);
		}

		return errorStates.build();
	}

	/* IFilterSlotDelegate */
	@Override
	public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		if (slotIndex == SLOT_ENERGY) {
			return isEnergy(itemStack);
		} else if (slotIndex == SLOT_SPECIMEN) {
			return BeeManager.beeRoot.isMember(itemStack);
		}
		return false;
	}

}
