/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.core.utils.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class ModelUtil {
    private static final Map<ResourceLocation, ModelBlockDefinition> blockDefinitions = Maps.newHashMap();

    public static boolean resourceExists(ResourceLocation location) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            resourceManager.func_110536_a(location);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static IBakedModel getModel(ItemStack stack) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        if (renderItem == null || renderItem.func_175037_a() == null) {
            return null;
        }
        return renderItem.func_175037_a().func_178089_a(stack);
    }

    public static SimpleModelState loadModelState(ResourceLocation location) {
        return new SimpleModelState(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)ModelUtil.loadTransformFromJson(location)));
    }

    private static ItemCameraTransforms loadTransformFromJson(ResourceLocation location) {
        try {
            return ModelBlock.func_178307_a((Reader)ModelUtil.getReaderForResource(location)).func_181682_g();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private static Reader getReaderForResource(ResourceLocation location) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8));
    }

    public static ModelBlockDefinition getModelBlockDefinition(ResourceLocation location) {
        try {
            ResourceLocation resourcelocation = ModelUtil.getBlockstateLocation(location);
            return blockDefinitions.computeIfAbsent(resourcelocation, k -> ModelUtil.loadMultipartMBD(location, resourcelocation));
        }
        catch (Exception exception) {
            Log.error("Failed to getModelBlockDefinition", exception);
            return new ModelBlockDefinition(new ArrayList());
        }
    }

    private static ResourceLocation getBlockstateLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
    }

    private static ModelBlockDefinition loadMultipartMBD(ResourceLocation location, ResourceLocation fileIn) {
        ArrayList list = Lists.newArrayList();
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager manager = mc.func_110442_L();
        try {
            for (IResource resource : manager.func_135056_b(fileIn)) {
                list.add(ModelUtil.loadModelBlockDefinition(location, resource));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered an exception when loading model definition of model " + fileIn, e);
        }
        return new ModelBlockDefinition((List)list);
    }

    private static ModelBlockDefinition loadModelBlockDefinition(ResourceLocation location, IResource resource) {
        ModelBlockDefinition definition;
        InputStream inputStream = null;
        try {
            inputStream = resource.func_110527_b();
            definition = ModelBlockDefinition.parseFromReader((Reader)new InputStreamReader(inputStream, Charsets.UTF_8), (ResourceLocation)location);
        }
        catch (Exception exception) {
            throw new RuntimeException("Encountered an exception when loading model definition of '" + location + "' from: '" + resource.func_177241_a() + "' in resourcepack: '" + resource.func_177240_d() + "'", exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return definition;
    }
}

