/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.gui;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;

import forestry.api.climate.IClimateListener;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.climate.ClimateRoot;
import forestry.core.gui.ContainerAnalyzerProvider;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.packets.PacketGuiUpdate;

public class ContainerBeeHousing extends ContainerAnalyzerProvider<TileBeeHousingBase> implements IContainerBeeHousing {

	public ContainerBeeHousing(InventoryPlayer player, TileBeeHousingBase tile, boolean hasFrames) {
		super(tile, player, 8, 108);
		ContainerBeeHelper.addSlots(this, tile, hasFrames);

		tile.getBeekeepingLogic().clearCachedValues();
		IClimateListener listener = ClimateRoot.getInstance().getListener(tile.func_145831_w(), tile.func_174877_v());
		if(listener != null && player.field_70458_d instanceof EntityPlayerMP){
			listener.syncToClient((EntityPlayerMP) player.field_70458_d);
		}
	}

	private int beeProgress = -1;

	@Override
	public void func_75142_b() {
		super.func_75142_b();

		int beeProgress = tile.getBeekeepingLogic().getBeeProgressPercent();
		if (this.beeProgress != beeProgress) {
			this.beeProgress = beeProgress;
			IForestryPacketClient packet = new PacketGuiUpdate(tile);
			sendPacketToListeners(packet);
		}
	}

}
