/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.ModuleCharcoal;
import forestry.arboriculture.blocks.BlockAsh;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWoodPile
extends Block
implements IItemModelRegister,
IStateMapperRegister {
    public static final PropertyBool IS_ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final int RANDOM_TICK = 160;

    public BlockWoodPile() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_ACTIVE, AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_ACTIVE) != false ? 8 + (Integer)state.func_177229_b((IProperty)AGE) : (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = meta > 7;
        return this.func_176223_P().func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta - (isActive ? 8 : 0)));
    }

    public int func_149738_a(World world) {
        return 960;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IBlockState facingState = world.func_180495_p(pos.func_177972_a(facing));
                if (facingState.func_177230_c() != this || !((Boolean)facingState.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) continue;
                world.func_175656_a(pos, state.func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                break;
            }
        }
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(160));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block fromBlock, BlockPos fromPos) {
        boolean isActive = (Boolean)state.func_177229_b((IProperty)IS_ACTIVE);
        if (fromBlock == Blocks.field_150480_ab && !isActive) {
            this.activatePile(state, world, pos, true);
        }
    }

    private void activatePile(IBlockState state, World world, BlockPos pos, boolean scheduleUpdate) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)IS_ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        if (scheduleUpdate) {
            world.func_175684_a(pos, (Block)this, (this.func_149738_a(world) + world.field_73012_v.nextInt(160)) / 4);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos position = pos.func_177972_a(facing);
                IBlockState blockState = world.func_180495_p(position);
                Block block = blockState.func_177230_c();
                if (block == this) {
                    if (!((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue() && ((Boolean)blockState.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
                        this.activatePile(state, world, pos, false);
                        continue;
                    }
                    if (((Boolean)blockState.func_177229_b((IProperty)IS_ACTIVE)).booleanValue() || !((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) continue;
                    this.activatePile(blockState, world, position, true);
                    continue;
                }
                if (!world.func_175623_d(position) && blockState.isSideSolid((IBlockAccess)world, position, facing.func_176734_d()) && !block.isFlammable((IBlockAccess)world, position, facing.func_176734_d())) continue;
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                return;
            }
            if (rand.nextFloat() < 0.5f) {
                if ((Integer)state.func_177229_b((IProperty)AGE) < 7) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)), 2);
                } else {
                    IBlockState ashState = ModuleCharcoal.getBlocks().ash.func_176223_P();
                    world.func_180501_a(pos, ashState.func_177226_a((IProperty)BlockAsh.AMOUNT, (Comparable)Integer.valueOf(Math.round(this.getCharcoalAmount(world, pos)))), 2);
                }
            }
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(160));
        }
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 12;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 25;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            return 10;
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)IS_ACTIVE)).booleanValue()) {
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (rand.nextDouble() < 0.2) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.15, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3) - 0.5, (double)(f1 + 1.0f), (double)(f2 + f4), 0.0, 0.15, 0.0, new int[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0);
    }

    private float getCharcoalAmount(World world, BlockPos pos) {
        float charcoalAmount = 0.0f;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            charcoalAmount += (float)this.getCharcoalFaceAmount(world, pos, facing);
        }
        return Math.min(charcoalAmount / 6.0f, 15.0f);
    }

    private int getCharcoalFaceAmount(World world, BlockPos pos, EnumFacing facing) {
        ICharcoalManager charcoalManager = (ICharcoalManager)Preconditions.checkNotNull((Object)TreeManager.charcoalManager);
        Collection<ICharcoalPileWall> walls = charcoalManager.getWalls();
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(pos);
        testPos.func_189536_c(facing);
        while (!world.func_175623_d((BlockPos)testPos) && world.func_175667_e((BlockPos)testPos)) {
            testPos.func_189536_c(facing);
            IBlockState state = world.func_180495_p((BlockPos)testPos);
            for (ICharcoalPileWall wall : walls) {
                if (!wall.matches(state)) continue;
                return wall.getCharcoalAmount();
            }
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{AGE, IS_ACTIVE}).func_178441_a());
    }
}

