/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.climate.ClimateManager;
import forestry.api.climate.IClimateListener;
import forestry.api.climate.IClimateProvider;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IWorldClimateHolder;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ILocatable;
import forestry.core.climate.AbsentClimateState;
import forestry.core.climate.ClimateRoot;
import forestry.core.climate.ClimateStateHelper;
import forestry.core.network.packets.PacketClimateListenerUpdate;
import forestry.core.network.packets.PacketClimateListenerUpdateEntity;
import forestry.core.network.packets.PacketClimateListenerUpdateEntityRequest;
import forestry.core.network.packets.PacketClimateListenerUpdateRequest;
import forestry.core.render.ParticleRender;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.TickHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClimateListener
implements IClimateListener {
    public static final int SERVER_UPDATE = 250;
    private final Object locationProvider;
    @Nullable
    protected World world;
    @Nullable
    protected BlockPos pos;
    private IClimateState cachedState = AbsentClimateState.INSTANCE;
    private IClimateState cachedClientState = AbsentClimateState.INSTANCE;
    @SideOnly(value=Side.CLIENT)
    private TickHelper tickHelper = new TickHelper();
    @SideOnly(value=Side.CLIENT)
    protected boolean needsClimateUpdate = true;
    private long cacheTime = 0L;
    private long lastUpdate = 0L;

    public ClimateListener(Object locationProvider) {
        this.locationProvider = locationProvider;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClientSide(boolean spawnParticles) {
        if (spawnParticles) {
            this.tickHelper.onTick();
            if (this.cachedState.isPresent() && this.tickHelper.updateOnInterval(20)) {
                World worldObj = this.getWorldObj();
                BlockPos coordinates = this.getCoordinates();
                ParticleRender.addTransformParticles(worldObj, coordinates, worldObj.field_73012_v);
            }
        }
        if (this.needsClimateUpdate) {
            if (this.locationProvider instanceof Entity) {
                NetworkUtil.sendToServer(new PacketClimateListenerUpdateEntityRequest((Entity)this.locationProvider));
            } else {
                NetworkUtil.sendToServer(new PacketClimateListenerUpdateRequest(this.getCoordinates()));
            }
            this.needsClimateUpdate = false;
        }
    }

    private void updateState(boolean syncToClient) {
        IWorldClimateHolder climateHolder = ClimateManager.climateRoot.getWorldClimate(this.getWorldObj());
        long totalTime = this.getWorldObj().func_82737_E();
        if (this.cacheTime + 250L > totalTime && climateHolder.getLastUpdate(this.getCoordinates()) == this.lastUpdate) {
            return;
        }
        this.lastUpdate = climateHolder.getLastUpdate(this.getCoordinates());
        this.cachedState = climateHolder.getState(this.getCoordinates());
        this.cacheTime = totalTime;
        if (syncToClient) {
            this.syncToClient();
        }
    }

    private IClimateState getState() {
        return this.getState(true);
    }

    private IClimateState getState(boolean update) {
        return this.getState(update, true);
    }

    private IClimateState getState(boolean update, boolean syncToClient) {
        World worldObj = this.getWorldObj();
        if (!worldObj.field_72995_K && update) {
            this.updateState(syncToClient);
        }
        return this.cachedState;
    }

    private IClimateProvider getDefaultProvider() {
        IClimateProvider provider = this.locationProvider instanceof IClimateProvider ? (IClimateProvider)this.locationProvider : ClimateRoot.getInstance().getDefaultClimate(this.getWorldObj(), this.getCoordinates());
        return provider;
    }

    @Override
    public Biome getBiome() {
        IClimateProvider provider = this.getDefaultProvider();
        return provider.getBiome();
    }

    @Override
    public EnumTemperature getTemperature() {
        Biome biome = this.getBiome();
        if (BiomeHelper.isBiomeHellish(biome)) {
            return EnumTemperature.HELLISH;
        }
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        float temperature;
        IClimateState climateState = this.getState();
        if (climateState.isPresent()) {
            temperature = climateState.getTemperature();
        } else {
            Biome biome = this.getBiome();
            temperature = biome.func_180626_a(this.getCoordinates());
        }
        return temperature;
    }

    @Override
    public float getExactHumidity() {
        float humidity;
        IClimateState climateState = this.getState();
        if (climateState.isPresent()) {
            humidity = climateState.getHumidity();
        } else {
            Biome biome = this.getBiome();
            humidity = biome.func_76727_i();
        }
        return humidity;
    }

    @Override
    public IClimateState getClimateState() {
        return ClimateStateHelper.of(this.getExactTemperature(), this.getExactHumidity());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setClimateState(IClimateState climateState) {
        this.cachedState = climateState;
    }

    @Override
    public void syncToClient() {
        if (!this.cachedState.equals(this.cachedClientState)) {
            World worldObj = this.getWorldObj();
            if (!worldObj.field_72995_K) {
                BlockPos coordinates = this.getCoordinates();
                if (this.locationProvider instanceof Entity) {
                    NetworkUtil.sendNetworkPacket(new PacketClimateListenerUpdateEntity((Entity)this.locationProvider, this.cachedState), coordinates, worldObj);
                } else {
                    NetworkUtil.sendNetworkPacket(new PacketClimateListenerUpdate(this.getCoordinates(), this.cachedState), coordinates, this.getWorldObj());
                }
            }
            this.cachedClientState = this.cachedState;
        }
    }

    @Override
    public void syncToClient(EntityPlayerMP player) {
        World worldObj = this.getWorldObj();
        if (!worldObj.field_72995_K) {
            IClimateState climateState = this.getState(true, false);
            if (this.locationProvider instanceof Entity) {
                NetworkUtil.sendToPlayer(new PacketClimateListenerUpdateEntity((Entity)this.locationProvider, climateState), (EntityPlayer)player);
            } else {
                NetworkUtil.sendToPlayer(new PacketClimateListenerUpdate(this.getCoordinates(), climateState), (EntityPlayer)player);
            }
        }
    }

    @Override
    public BlockPos getCoordinates() {
        if (this.pos == null) {
            this.initLocation();
        }
        return this.pos;
    }

    @Override
    public World getWorldObj() {
        if (this.world == null) {
            this.initLocation();
        }
        return this.world;
    }

    @Override
    public void markLocatableDirty() {
        this.world = null;
        this.pos = null;
        World worldObj = this.getWorldObj();
        if (!worldObj.field_72995_K) {
            this.updateState(true);
        }
    }

    private void initLocation() {
        if (this.locationProvider instanceof ILocatable) {
            ILocatable provider = (ILocatable)this.locationProvider;
            this.world = provider.getWorldObj();
            this.pos = provider.getCoordinates();
        } else if (this.locationProvider instanceof TileEntity) {
            TileEntity provider = (TileEntity)this.locationProvider;
            this.world = provider.func_145831_w();
            this.pos = provider.func_174877_v();
        } else {
            throw new IllegalStateException("no / incompatible location provider");
        }
    }
}

