/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import forestry.core.config.Config;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.Translator;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;

public class GreenhouseEnergyLedger
extends Ledger {
    final IGreenhouseControllerInternal controller;

    public GreenhouseEnergyLedger(LedgerManager ledgerManager, IGreenhouseControllerInternal controller) {
        super(ledgerManager, "power");
        this.maxHeight = 48;
        this.controller = controller;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawSprite(TextureManagerForestry.getInstance().getDefault("misc/energy"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(Translator.translateToLocal("for.gui.energy"), x + 22, y + 8);
        this.drawSubheader(Translator.translateToLocal("for.gui.stored") + ':', x + 22, y + 20);
        this.drawText(Config.energyDisplayMode.formatEnergyValue(this.controller.getEnergyManager().getEnergyStored()), x + 22, y + 32);
    }

    @Override
    public String getTooltip() {
        return Translator.translateToLocal("for.gui.energy") + ": " + this.controller.getEnergyManager().getEnergyStored() + " RF/t";
    }
}

