/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics.alleles;

import forestry.api.lepidopterology.IAlleleButterflyCocoon;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.lepidopterology.blocks.PropertyCocoon;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;

public class AlleleButterflyCocoon
extends AlleleCategorized
implements IAlleleButterflyCocoon {
    public static final PropertyCocoon COCOON = new PropertyCocoon("cocoon");
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    private final Map<ItemStack, Float> loot = new HashMap<ItemStack, Float>();
    private final String name;

    public AlleleButterflyCocoon(String name, boolean isDominant) {
        super("forestry", "cocoon", name, isDominant);
        this.name = name;
    }

    private static String getAgeKey(int age) {
        if (age == 0) {
            return "early";
        }
        if (age == 1) {
            return "middle";
        }
        return "late";
    }

    @Override
    public String getCocoonName() {
        return this.name;
    }

    @Override
    public ModelResourceLocation getCocoonItemModel(int age) {
        return new ModelResourceLocation("forestry:lepidopterology/cocoons/cocoon_" + this.name + "_" + AlleleButterflyCocoon.getAgeKey(age), "inventory");
    }

    @Override
    public void clearLoot() {
        this.loot.clear();
    }

    @Override
    public void addLoot(ItemStack loot, float chance) {
        this.loot.put(loot, Float.valueOf(chance));
    }

    @Override
    public Map<ItemStack, Float> getCocoonLoot() {
        return Collections.unmodifiableMap(this.loot);
    }

    @Override
    public int compareTo(IAlleleButterflyCocoon o) {
        return 0;
    }
}

